/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.tracker;

import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.tracker.AbstractTracker;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.hammy275.immersivemc.server.tracker.ServerTrackerInit;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class CampfireTracker
extends AbstractTracker {
    public static final Map<String, CookInfo> cookTime = new HashMap<String, CookInfo>();

    public CampfireTracker() {
        ServerTrackerInit.playerTrackers.add(this);
    }

    @Override
    protected void tick(Player player) {
        CookInfo info = cookTime.get(player.getGameProfile().getName());
        if (info == null) {
            return;
        }
        for (int c = 0; c <= 1; ++c) {
            ItemStack toSmelt = c == 0 ? player.getItemInHand(InteractionHand.MAIN_HAND) : player.getItemInHand(InteractionHand.OFF_HAND);
            Optional recipe = player.level().getRecipeManager().getRecipeFor(RecipeType.CAMPFIRE_COOKING, (RecipeInput)new SingleRecipeInput(toSmelt), player.level());
            if (recipe.isPresent() && info.get(c) >= ((CampfireCookingRecipe)((RecipeHolder)recipe.get()).value()).getCookingTime() / 2) {
                toSmelt.shrink(1);
                boolean didGive = player.getInventory().add(((CampfireCookingRecipe)((RecipeHolder)recipe.get()).value()).getResultItem((HolderLookup.Provider)player.level().registryAccess()).copy());
                if (!didGive) {
                    Util.placeLeftovers(player, ((CampfireCookingRecipe)((RecipeHolder)recipe.get()).value()).getResultItem((HolderLookup.Provider)player.level().registryAccess()).copy());
                }
                cookTime.remove(player.getGameProfile().getName());
                continue;
            }
            if (!recipe.isPresent() || ThreadLocalRandom.current().nextInt(4) != 0) continue;
            Vec3 pos = VRPlugin.API.getVRPlayer(player).getController(c).position();
            Level level = player.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, pos.x, pos.y, pos.z, 1, 0.01, 0.01, 0.01, 0.0);
        }
    }

    @Override
    protected boolean shouldTick(Player player) {
        if (!ActiveConfig.FILE_SERVER.useCampfireImmersive) {
            return false;
        }
        if (!VRPluginVerify.hasAPI) {
            return false;
        }
        if (!VRPlugin.API.playerInVR(player)) {
            return false;
        }
        if (!ActiveConfig.getConfigForPlayer((Player)player).useCampfireImmersive) {
            return false;
        }
        IVRPlayer vrPlayer = VRPlugin.API.getVRPlayer(player);
        boolean mainRes = false;
        boolean offRes = false;
        for (int c = 0; c <= 1; ++c) {
            ItemStack stackOld;
            BlockState campfire;
            IVRData controller = vrPlayer.getController(c);
            BlockPos pos = BlockPos.containing((Position)controller.position());
            if (!(player.level().getBlockState(pos).getBlock() instanceof CampfireBlock) && !(player.level().getBlockState(pos.below()).getBlock() instanceof CampfireBlock) || !((Boolean)(campfire = player.level().getBlockState(pos).getBlock() instanceof CampfireBlock ? player.level().getBlockState(pos) : player.level().getBlockState(pos.below())).getValue((Property)CampfireBlock.LIT)).booleanValue()) continue;
            ItemStack stackNew = c == 0 ? player.getItemInHand(InteractionHand.MAIN_HAND) : player.getItemInHand(InteractionHand.OFF_HAND);
            CookInfo info = cookTime.get(player.getGameProfile().getName());
            if (info == null) {
                info = new CookInfo();
                cookTime.put(player.getGameProfile().getName(), info);
            }
            if (stackNew == (stackOld = info.getStack(c)) || stackOld.isEmpty()) {
                info.add(c, 1);
                if (c == 0) {
                    mainRes = true;
                } else {
                    offRes = true;
                }
            }
            info.setStack(c, stackNew);
        }
        return mainRes || offRes;
    }

    public static class CookInfo {
        protected int mainHand = 0;
        protected int offHand = 0;
        public ItemStack stackHeldMain = ItemStack.EMPTY;
        public ItemStack stackHeldOff = ItemStack.EMPTY;

        public void set(int controller, int value) {
            if (controller == 0) {
                this.mainHand = value;
            } else {
                this.offHand = value;
            }
        }

        public int get(int controller) {
            return controller == 0 ? this.mainHand : this.offHand;
        }

        public void add(int controller, int amount) {
            this.set(controller, this.get(controller) + amount);
        }

        public ItemStack getStack(int controller) {
            return controller == 0 ? this.stackHeldMain : this.stackHeldOff;
        }

        public void setStack(int controller, ItemStack stack) {
            if (controller == 0) {
                this.stackHeldMain = stack;
            } else {
                this.stackHeldOff = stack;
            }
        }

        public String toString() {
            return "Main Hand: " + String.valueOf(this.stackHeldMain) + " w/ " + this.mainHand + " ticks\nOff Hand: " + String.valueOf(this.stackHeldOff) + " w/ " + this.offHand + " ticks";
        }
    }
}

