/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.tracker.vrhand;

import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.server.data.LastTickData;
import com.hammy275.immersivemc.server.tracker.ServerTrackerInit;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractVRHandTracker {
    public AbstractVRHandTracker() {
        ServerTrackerInit.vrPlayerTrackers.add(this);
    }

    protected abstract boolean shouldRunForHand(Player var1, InteractionHand var2, ItemStack var3, IVRPlayer var4, LastTickData var5);

    protected abstract void runForHand(Player var1, InteractionHand var2, ItemStack var3, IVRPlayer var4, LastTickData var5);

    public abstract boolean isEnabledInConfig(ActiveConfig var1);

    public void preTick(Player player) {
    }

    public void tick(Player player, IVRPlayer currentVRData, LastTickData lastVRData) {
        for (InteractionHand hand : InteractionHand.values()) {
            if (!this.shouldRunForHand(player, hand, player.getItemInHand(hand), currentVRData, lastVRData)) continue;
            this.runForHand(player, hand, player.getItemInHand(hand), currentVRData, lastVRData);
        }
    }

    protected BlockPos getBlockPosAtHand(IVRPlayer vrPlayer, InteractionHand hand) {
        IVRData data = vrPlayer.getController(hand.ordinal());
        return BlockPos.containing((Position)data.position());
    }

    protected BlockState getBlockStateAtHand(Player player, IVRPlayer vrPlayer, InteractionHand hand) {
        return player.level().getBlockState(this.getBlockPosAtHand(vrPlayer, hand));
    }

    protected Block getBlockAtHand(Player player, IVRPlayer vrPlayer, InteractionHand hand) {
        return this.getBlockStateAtHand(player, vrPlayer, hand).getBlock();
    }

    protected boolean movingInDirectionWithThreshold(Direction direction, Vec3 handVelocity, double threshold) {
        Vec3i blockFacing = direction.getNormal();
        if (this.signsMatch(blockFacing.getX(), handVelocity.x) && blockFacing.getX() != 0) {
            return Math.abs(handVelocity.x) >= threshold;
        }
        if (this.signsMatch(blockFacing.getY(), handVelocity.y) && blockFacing.getY() != 0) {
            return Math.abs(handVelocity.y) >= threshold;
        }
        if (this.signsMatch(blockFacing.getZ(), handVelocity.z) && blockFacing.getZ() != 0) {
            return Math.abs(handVelocity.z) >= threshold;
        }
        return false;
    }

    protected boolean signsMatch(double a, double b) {
        return a < 0.0 && b < 0.0 || a >= 0.0 && b >= 0.0;
    }
}

