/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.tracker.vrhand;

import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.vr.VRRumble;
import com.hammy275.immersivemc.server.data.LastTickData;
import com.hammy275.immersivemc.server.tracker.vrhand.AbstractVRHandTracker;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemStack;

public class ArmorTracker
extends AbstractVRHandTracker {
    @Override
    protected boolean shouldRunForHand(Player player, InteractionHand hand, ItemStack stackInHand, IVRPlayer currentVRData, LastTickData lastVRData) {
        return player.getBoundingBox().contains(currentVRData.getController(hand.ordinal()).position()) && stackInHand.getItem() instanceof Equipable;
    }

    @Override
    protected void runForHand(Player player, InteractionHand hand, ItemStack stackInHand, IVRPlayer currentVRData, LastTickData lastVRData) {
        boolean shouldEquip;
        EquipmentSlot slot = player.getEquipmentSlotForItem(stackInHand);
        if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) {
            return;
        }
        if (!((ItemStack)player.getInventory().armor.get(slot.getIndex())).isEmpty()) {
            return;
        }
        switch (slot) {
            case HEAD: {
                shouldEquip = player.getEyePosition().distanceToSqr(currentVRData.getController(hand.ordinal()).position()) <= 0.25;
                break;
            }
            case CHEST: {
                shouldEquip = player.position().add(0.0, 1.2, 0.0).distanceToSqr(currentVRData.getController(hand.ordinal()).position()) <= 0.25;
                break;
            }
            case LEGS: {
                shouldEquip = player.position().add(0.0, 0.7, 0.0).distanceToSqr(currentVRData.getController(hand.ordinal()).position()) <= 0.140625;
                break;
            }
            case FEET: {
                shouldEquip = player.position().distanceToSqr(currentVRData.getController(hand.ordinal()).position()) <= 0.25;
                break;
            }
            default: {
                return;
            }
        }
        if (shouldEquip) {
            ItemStack toEquip = stackInHand.copy();
            toEquip.setCount(1);
            player.getInventory().armor.set(slot.getIndex(), (Object)toEquip);
            stackInHand.shrink(1);
            VRRumble.rumbleIfVR(player, hand.ordinal(), 0.05f);
        }
    }

    @Override
    public boolean isEnabledInConfig(ActiveConfig config) {
        return config.useArmorImmersive;
    }
}

