/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.tracker.vrhand;

import com.hammy275.immersivemc.Platform;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.mixin.AbstractCauldronBlockAccessor;
import com.hammy275.immersivemc.server.data.LastTickData;
import com.hammy275.immersivemc.server.tracker.vrhand.AbstractVRHandTracker;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BottleItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;

public class CauldronTracker
extends AbstractVRHandTracker {
    private Map<UUID, Integer> cooldown = new HashMap<UUID, Integer>();

    @Override
    public void preTick(Player player) {
        super.preTick(player);
        int newCooldown = this.cooldown.getOrDefault(player.getUUID(), 0) - 1;
        if (newCooldown <= 0) {
            this.cooldown.remove(player.getUUID());
        } else {
            this.cooldown.put(player.getUUID(), newCooldown);
        }
    }

    @Override
    protected boolean shouldRunForHand(Player player, InteractionHand hand, ItemStack stackInHand, IVRPlayer currentVRData, LastTickData lastVRData) {
        if (this.cooldown.getOrDefault(player.getUUID(), 0) > 0) {
            return false;
        }
        IVRData data = currentVRData.getController(hand.ordinal());
        return player.level().getBlockState(BlockPos.containing((Position)data.position())).getBlock() instanceof AbstractCauldronBlock || player.level().getBlockState(BlockPos.containing((Position)data.position()).below()).getBlock() instanceof AbstractCauldronBlock && player.level().getBlockState(BlockPos.containing((Position)data.position())).isAir();
    }

    @Override
    protected void runForHand(Player player, InteractionHand hand, ItemStack stackInHand, IVRPlayer currentVRData, LastTickData lastVRData) {
        BucketItem bucketItem;
        BucketItem bucketItem2;
        IVRData data = currentVRData.getController(hand.ordinal());
        BlockState handState = player.level().getBlockState(BlockPos.containing((Position)data.position()));
        BlockPos cauldronPos = handState.getBlock() instanceof AbstractCauldronBlock ? BlockPos.containing((Position)data.position()) : BlockPos.containing((Position)data.position()).below();
        BlockState cauldron = player.level().getBlockState(cauldronPos);
        AbstractCauldronBlock cauldronBlock = (AbstractCauldronBlock)cauldron.getBlock();
        boolean inCauldronBlock = handState.getBlock() instanceof AbstractCauldronBlock;
        ItemStack handStack = player.getItemInHand(hand);
        Item handItem = handStack.getItem();
        PotionContents contents = (PotionContents)handStack.get(DataComponents.POTION_CONTENTS);
        Holder heldPotion = contents == null ? null : (Holder)contents.potion().orElse(null);
        CauldronInteraction interaction = (CauldronInteraction)((AbstractCauldronBlockAccessor)cauldronBlock).immersiveMC$getInteractions().map().get(handItem);
        if (interaction == null) {
            return;
        }
        if (inCauldronBlock && (handItem instanceof BottleItem || handItem instanceof BucketItem && Platform.getFluid(bucketItem2 = (BucketItem)handItem).isSame(Fluids.EMPTY))) {
            if (Math.abs(data.getRoll()) < 90.0f) {
                this.possiblySetCooldown(player, interaction.interact(cauldron, player.level(), cauldronPos, player, hand, handStack));
            }
        } else if (handItem instanceof PotionItem && heldPotion == Potions.WATER || handItem instanceof BucketItem && !Platform.getFluid(bucketItem = (BucketItem)handItem).isSame(Fluids.EMPTY) || handItem instanceof SolidBucketItem) {
            if (Math.abs(data.getRoll()) > 160.0f) {
                this.possiblySetCooldown(player, interaction.interact(cauldron, player.level(), cauldronPos, player, hand, handStack));
            }
        } else if (inCauldronBlock) {
            this.possiblySetCooldown(player, interaction.interact(cauldron, player.level(), cauldronPos, player, hand, handStack));
        }
    }

    @Override
    public boolean isEnabledInConfig(ActiveConfig config) {
        return config.useCauldronImmersive;
    }

    private void possiblySetCooldown(Player player, ItemInteractionResult res) {
        if (res.consumesAction()) {
            this.cooldown.put(player.getUUID(), 5);
        }
    }
}

