/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.tracker.vrhand;

import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.vr.VRRumble;
import com.hammy275.immersivemc.server.data.LastTickData;
import com.hammy275.immersivemc.server.tracker.vrhand.AbstractVRHandsTracker;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FeedAnimalsTracker
extends AbstractVRHandsTracker {
    public static final int COOLDOWN_TICKS = 20;
    protected Map<String, Integer> cooldown = new HashMap<String, Integer>();

    @Override
    public boolean isEnabledInConfig(ActiveConfig config) {
        return config.useFeedingAnimalsImmersive;
    }

    @Override
    protected boolean shouldRun(Player player, IVRPlayer vrPlayer, LastTickData lastVRData) {
        int currentCooldown = this.cooldown.getOrDefault(player.getGameProfile().getName(), 0);
        if (currentCooldown > 0) {
            this.cooldown.put(player.getGameProfile().getName(), --currentCooldown);
        }
        return (!player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() || !player.getItemInHand(InteractionHand.OFF_HAND).isEmpty()) && currentCooldown <= 0;
    }

    @Override
    protected void run(Player player, IVRPlayer vrPlayer, LastTickData lastVRData) {
        InteractionHand hand = player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack inHand = player.getItemInHand(hand);
        if (inHand.isEmpty()) {
            return;
        }
        List<Animal> nearbyEnts = FeedAnimalsTracker.getLivingNearby(player);
        for (Animal animal : nearbyEnts) {
            InteractionResult res;
            AABB feedbox;
            if (!animal.isFood(inHand) || !(feedbox = FeedAnimalsTracker.getMouthHitbox((LivingEntity)animal)).contains(vrPlayer.getController0().position()) || !feedbox.contains(vrPlayer.getController1().position()) || !(vrPlayer.getController0().position().distanceToSqr(vrPlayer.getController1().position()) < 0.5) || (res = animal.mobInteract(player, hand)) != InteractionResult.CONSUME && res != InteractionResult.SUCCESS) continue;
            this.cooldown.put(player.getGameProfile().getName(), 20);
            VRRumble.doubleRumbleIfVR(player, 0.05f);
            break;
        }
    }

    public static AABB getMouthHitbox(LivingEntity entity) {
        return AABB.ofSize((Vec3)entity.getEyePosition(), (double)((double)entity.getBbWidth() * 2.25), (double)((double)entity.getBbHeight() * 0.5), (double)((double)entity.getBbWidth() * 2.25));
    }

    public static List<Animal> getLivingNearby(Player player) {
        AABB checkArea = AABB.ofSize((Vec3)player.position(), (double)6.0, (double)6.0, (double)6.0);
        List ents = player.level().getEntities((Entity)player, checkArea, e -> e instanceof Animal);
        LinkedList<Animal> nearby = new LinkedList<Animal>();
        for (Entity e2 : ents) {
            nearby.add((Animal)e2);
        }
        return nearby;
    }
}

