/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.tracker.vrhand;

import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.server.LastTickVRData;
import com.hammy275.immersivemc.server.data.LastTickData;
import com.hammy275.immersivemc.server.tracker.vrhand.AbstractVRHandTracker;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Mule;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PetTracker
extends AbstractVRHandTracker {
    public static final double THRESHOLD = 0.02;

    @Override
    protected boolean shouldRunForHand(Player player, InteractionHand hand, ItemStack stackInHand, IVRPlayer currentVRData, LastTickData lastVRData) {
        return this.getPlayerPetsNearby(player).size() > 0;
    }

    @Override
    protected void runForHand(Player player, InteractionHand hand, ItemStack stackInHand, IVRPlayer currentVRData, LastTickData lastVRData) {
        if (ThreadLocalRandom.current().nextInt(20) == 0) {
            for (LivingEntity entity : this.getPlayerPetsNearby(player)) {
                if (!entity.getBoundingBox().inflate(0.2).contains(currentVRData.getController(hand.ordinal()).position()) || !(LastTickVRData.getAllVelocity(lastVRData.lastPlayer.getController(hand.ordinal()), currentVRData.getController(hand.ordinal()), lastVRData) >= 0.02)) continue;
                ServerLevel level = (ServerLevel)player.level();
                Vec3 pos = currentVRData.getController(hand.ordinal()).position();
                level.sendParticles((ParticleOptions)ParticleTypes.HEART, pos.x, pos.y, pos.z, ThreadLocalRandom.current().nextInt(5) + 1, 0.25, 0.1, 0.25, 1.0E-5);
                if (ThreadLocalRandom.current().nextInt(5) != 0) continue;
                SoundEvent sound = null;
                if (entity instanceof Wolf) {
                    sound = SoundEvents.WOLF_PANT;
                } else if (entity instanceof Cat) {
                    sound = SoundEvents.CAT_PURREOW;
                } else if (entity instanceof Horse) {
                    sound = SoundEvents.HORSE_AMBIENT;
                } else if (entity instanceof Donkey) {
                    sound = SoundEvents.DONKEY_AMBIENT;
                } else if (entity instanceof Mule) {
                    sound = SoundEvents.MULE_AMBIENT;
                }
                if (sound == null) continue;
                level.playSound(null, (Entity)entity, sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public boolean isEnabledInConfig(ActiveConfig config) {
        return config.allowPetting;
    }

    protected List<LivingEntity> getPlayerPetsNearby(Player player) {
        LinkedList<LivingEntity> pets = new LinkedList<LivingEntity>();
        List ents = player.level().getEntities((Entity)player, AABB.ofSize((Vec3)player.position(), (double)10.0, (double)10.0, (double)10.0));
        for (Entity e : ents) {
            AbstractHorse horse;
            if (ActiveConfig.getConfigForPlayer((Player)player).allowPettingAnythingLiving) {
                if (!(e instanceof LivingEntity)) continue;
                LivingEntity le = (LivingEntity)e;
                pets.add(le);
                continue;
            }
            if (e instanceof TamableAnimal) {
                TamableAnimal ta = (TamableAnimal)e;
                if (ta.getOwner() != player) continue;
                pets.add((LivingEntity)ta);
                continue;
            }
            if (!(e instanceof AbstractHorse) || !(horse = (AbstractHorse)e).isTamed()) continue;
            pets.add((LivingEntity)horse);
        }
        return pets;
    }
}

