/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.block.machinery;

import com.buuz135.sushigocrafting.tile.machinery.RiceCookerTile;
import com.hrznstudio.titanium.block.RotatableBlock;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RiceCookerBlock
extends RotatableBlock<RiceCookerTile> {
    public static VoxelShape SOUTH = Stream.of(Block.box((double)4.0, (double)15.0, (double)7.0, (double)12.0, (double)16.0, (double)9.0), Block.box((double)13.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)3.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)3.0, (double)1.0, (double)3.0), Block.box((double)13.0, (double)0.0, (double)13.0, (double)14.0, (double)1.0, (double)14.0), Block.box((double)2.0, (double)0.0, (double)13.0, (double)3.0, (double)1.0, (double)14.0), Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0), Block.box((double)6.0, (double)3.0, (double)0.5, (double)10.0, (double)7.0, (double)1.0), Block.box((double)7.0, (double)4.0, (double)0.0, (double)9.0, (double)6.0, (double)0.5), Block.box((double)15.0, (double)6.0, (double)5.0, (double)16.0, (double)8.0, (double)6.0), Block.box((double)0.0, (double)6.0, (double)5.0, (double)1.0, (double)8.0, (double)6.0), Block.box((double)15.0, (double)6.0, (double)10.0, (double)16.0, (double)8.0, (double)11.0), Block.box((double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)8.0, (double)11.0), Block.box((double)15.0, (double)8.0, (double)5.0, (double)16.0, (double)9.0, (double)11.0), Block.box((double)0.0, (double)8.0, (double)5.0, (double)1.0, (double)9.0, (double)11.0), Block.box((double)2.0, (double)13.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), Block.box((double)11.0, (double)14.0, (double)7.0, (double)12.0, (double)15.0, (double)9.0), Block.box((double)4.0, (double)14.0, (double)7.0, (double)5.0, (double)15.0, (double)9.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static VoxelShape WEST = Stream.of(Block.box((double)7.0, (double)15.0, (double)4.0, (double)9.0, (double)16.0, (double)12.0), Block.box((double)13.0, (double)0.0, (double)13.0, (double)14.0, (double)1.0, (double)14.0), Block.box((double)13.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)3.0), Block.box((double)2.0, (double)0.0, (double)13.0, (double)3.0, (double)1.0, (double)14.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)3.0, (double)1.0, (double)3.0), Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0), Block.box((double)15.0, (double)3.0, (double)6.0, (double)15.5, (double)7.0, (double)10.0), Block.box((double)15.5, (double)4.0, (double)7.0, (double)16.0, (double)6.0, (double)9.0), Block.box((double)10.0, (double)6.0, (double)15.0, (double)11.0, (double)8.0, (double)16.0), Block.box((double)10.0, (double)6.0, (double)0.0, (double)11.0, (double)8.0, (double)1.0), Block.box((double)5.0, (double)6.0, (double)15.0, (double)6.0, (double)8.0, (double)16.0), Block.box((double)5.0, (double)6.0, (double)0.0, (double)6.0, (double)8.0, (double)1.0), Block.box((double)5.0, (double)8.0, (double)15.0, (double)11.0, (double)9.0, (double)16.0), Block.box((double)5.0, (double)8.0, (double)0.0, (double)11.0, (double)9.0, (double)1.0), Block.box((double)2.0, (double)13.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), Block.box((double)7.0, (double)14.0, (double)11.0, (double)9.0, (double)15.0, (double)12.0), Block.box((double)7.0, (double)14.0, (double)4.0, (double)9.0, (double)15.0, (double)5.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static VoxelShape NORTH = Stream.of(Block.box((double)4.0, (double)15.0, (double)7.0, (double)12.0, (double)16.0, (double)9.0), Block.box((double)2.0, (double)0.0, (double)13.0, (double)3.0, (double)1.0, (double)14.0), Block.box((double)13.0, (double)0.0, (double)13.0, (double)14.0, (double)1.0, (double)14.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)3.0, (double)1.0, (double)3.0), Block.box((double)13.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)3.0), Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0), Block.box((double)6.0, (double)3.0, (double)15.0, (double)10.0, (double)7.0, (double)15.5), Block.box((double)7.0, (double)4.0, (double)15.5, (double)9.0, (double)6.0, (double)16.0), Block.box((double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)8.0, (double)11.0), Block.box((double)15.0, (double)6.0, (double)10.0, (double)16.0, (double)8.0, (double)11.0), Block.box((double)0.0, (double)6.0, (double)5.0, (double)1.0, (double)8.0, (double)6.0), Block.box((double)15.0, (double)6.0, (double)5.0, (double)16.0, (double)8.0, (double)6.0), Block.box((double)0.0, (double)8.0, (double)5.0, (double)1.0, (double)9.0, (double)11.0), Block.box((double)15.0, (double)8.0, (double)5.0, (double)16.0, (double)9.0, (double)11.0), Block.box((double)2.0, (double)13.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), Block.box((double)4.0, (double)14.0, (double)7.0, (double)5.0, (double)15.0, (double)9.0), Block.box((double)11.0, (double)14.0, (double)7.0, (double)12.0, (double)15.0, (double)9.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static VoxelShape EAST = Stream.of(Block.box((double)7.0, (double)15.0, (double)4.0, (double)9.0, (double)16.0, (double)12.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)3.0, (double)1.0, (double)3.0), Block.box((double)2.0, (double)0.0, (double)13.0, (double)3.0, (double)1.0, (double)14.0), Block.box((double)13.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)3.0), Block.box((double)13.0, (double)0.0, (double)13.0, (double)14.0, (double)1.0, (double)14.0), Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0), Block.box((double)0.5, (double)3.0, (double)6.0, (double)1.0, (double)7.0, (double)10.0), Block.box((double)0.0, (double)4.0, (double)7.0, (double)0.5, (double)6.0, (double)9.0), Block.box((double)5.0, (double)6.0, (double)0.0, (double)6.0, (double)8.0, (double)1.0), Block.box((double)5.0, (double)6.0, (double)15.0, (double)6.0, (double)8.0, (double)16.0), Block.box((double)10.0, (double)6.0, (double)0.0, (double)11.0, (double)8.0, (double)1.0), Block.box((double)10.0, (double)6.0, (double)15.0, (double)11.0, (double)8.0, (double)16.0), Block.box((double)5.0, (double)8.0, (double)0.0, (double)11.0, (double)9.0, (double)1.0), Block.box((double)5.0, (double)8.0, (double)15.0, (double)11.0, (double)9.0, (double)16.0), Block.box((double)2.0, (double)13.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), Block.box((double)7.0, (double)14.0, (double)4.0, (double)9.0, (double)15.0, (double)5.0), Block.box((double)7.0, (double)14.0, (double)11.0, (double)9.0, (double)15.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public RiceCookerBlock() {
        super("rice_cooker", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK), RiceCookerTile.class);
    }

    public Item asItem() {
        return Item.byBlock((Block)this);
    }

    public BlockEntityType.BlockEntitySupplier<?> getTileEntityFactory() {
        return RiceCookerTile::new;
    }

    public RotatableBlock.RotationType getRotationType() {
        return RotatableBlock.RotationType.FOUR_WAY;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)RotatableBlock.FACING_HORIZONTAL, (Comparable)context.getHorizontalDirection());
    }

    @Nonnull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        Direction direction = (Direction)state.getValue((Property)RotatableBlock.RotationType.FOUR_WAY.getProperties()[0]);
        if (direction == Direction.NORTH) {
            return NORTH;
        }
        if (direction == Direction.EAST) {
            return EAST;
        }
        if (direction == Direction.WEST) {
            return WEST;
        }
        return SOUTH;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)RotatableBlock.RotationType.FOUR_WAY.getProperties()[0]);
        if (direction == Direction.NORTH) {
            return NORTH;
        }
        if (direction == Direction.EAST) {
            return EAST;
        }
        if (direction == Direction.WEST) {
            return WEST;
        }
        return SOUTH;
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        super.animateTick(stateIn, worldIn, pos, rand);
        this.getTile((BlockGetter)worldIn, pos).filter(riceCookerTile -> riceCookerTile.getBar().getProgress() > 0).ifPresent(riceCookerTile -> {
            Direction direction = riceCookerTile.getFacingDirection().getOpposite();
            double d0 = (double)pos.getX() + 0.5;
            double d1 = (double)pos.getY() + 1.0;
            double d2 = (double)pos.getZ() + 0.5;
            if (rand.nextDouble() < 0.05) {
                worldIn.playLocalSound(d0, d1, d2, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 0.0f, true);
            }
            Direction.Axis direction$axis = direction.getAxis();
            double d3 = 0.52;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.getStepX() * 0.52 : d4;
            double d6 = rand.nextDouble() * 6.0 / 16.0;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.52 : d4;
            worldIn.addParticle((ParticleOptions)ParticleTypes.CLOUD, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
        });
    }
}

