/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.block.machinery;

import com.buuz135.sushigocrafting.tile.machinery.RollerTile;
import com.hrznstudio.titanium.block.RotatableBlock;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RollerBlock
extends RotatableBlock<RollerTile> {
    public static VoxelShape SHAPE_NORTH = Block.box((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)0.5, (double)15.0);
    public static VoxelShape SHAPE_EAST = Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)0.5, (double)14.0);

    public RollerBlock() {
        super("roller", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR), RollerTile.class);
    }

    public BlockEntityType.BlockEntitySupplier<?> getTileEntityFactory() {
        return RollerTile::new;
    }

    public Item asItem() {
        return Item.byBlock((Block)this);
    }

    public void attack(BlockState state, Level worldIn, BlockPos pos, Player player) {
        this.getTile((BlockGetter)worldIn, pos).ifPresent(rollerTile -> rollerTile.onClick(player));
    }

    @Nonnull
    public RotatableBlock.RotationType getRotationType() {
        return RotatableBlock.RotationType.FOUR_WAY;
    }

    @Nonnull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        Direction direction = (Direction)state.getValue((Property)RotatableBlock.FACING_HORIZONTAL);
        return direction == Direction.NORTH || direction == Direction.SOUTH ? SHAPE_NORTH : SHAPE_EAST;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)RotatableBlock.FACING_HORIZONTAL);
        return direction == Direction.NORTH || direction == Direction.SOUTH ? SHAPE_NORTH : SHAPE_EAST;
    }
}

