/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.client.gui;

import com.buuz135.sushigocrafting.api.IFoodIngredient;
import com.buuz135.sushigocrafting.api.IIngredientConsumer;
import com.buuz135.sushigocrafting.api.impl.FoodAPI;
import com.buuz135.sushigocrafting.cap.SushiWeightDiscoveryCapability;
import com.buuz135.sushigocrafting.client.gui.provider.SushiAssetTypes;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.buuz135.sushigocrafting.tile.machinery.RollerTile;
import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.network.Message;
import com.hrznstudio.titanium.network.locator.ILocatable;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import com.hrznstudio.titanium.util.AssetUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.apache.commons.lang3.tuple.Pair;

public abstract class RollerWeightSelectorButtonComponent
extends BasicScreenAddon {
    private final InventoryComponent<RollerTile> inventoryComponent;
    private final int slot;

    public RollerWeightSelectorButtonComponent(InventoryComponent inventoryComponent, int slot) {
        super(0, 0);
        this.inventoryComponent = inventoryComponent;
        this.slot = slot;
    }

    public static void drawBackground(GuiGraphics matrixStack, Screen screen, IAssetProvider iAssetProvider, int guiX, int guiY, int posX, int posY) {
        IAsset asset = iAssetProvider.getAsset(SushiAssetTypes.ROLLER_WEIGHT_PICKER_BG);
        if (asset != null) {
            AssetUtil.drawAsset((GuiGraphics)matrixStack, (Screen)screen, (IAsset)asset, (int)(guiX + posX), (int)(guiY + posY));
        }
    }

    public static void drawForeground(GuiGraphics matrixStack, Screen screen, IAssetProvider iAssetProvider, int guiX, int guiY, int posX, int posY, int weight, int ySize, String type, int slot) {
        SushiWeightDiscoveryCapability iSushiWeightDiscovery;
        IAsset asset = iAssetProvider.getAsset(SushiAssetTypes.ROLLER_WEIGHT_PICKER_POINTER);
        if (asset != null && weight != Integer.MIN_VALUE) {
            AssetUtil.drawAsset((GuiGraphics)matrixStack, (Screen)screen, (IAsset)asset, (int)posX, (int)(posY + (4 - weight) * (ySize / 4) - 1));
        }
        if ((iSushiWeightDiscovery = (SushiWeightDiscoveryCapability)Minecraft.getInstance().player.getData(SushiContent.AttachmentTypes.SUSHI_WEIGHT_DISCOVERY)).hasDiscovery(type + "-" + slot)) {
            int pos = posY + (4 - iSushiWeightDiscovery.getDiscovery(type + "-" + slot)) * (ySize / 4) - 1;
            AssetUtil.drawAsset((GuiGraphics)matrixStack, (Screen)screen, (IAsset)iAssetProvider.getAsset(SushiAssetTypes.ROLLER_WEIGHT_PERFECT_POINTER), (int)(posX + 1), (int)(pos + 1));
        }
    }

    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider iAssetProvider, int guiX, int guiY, int mouseX, int mouseY, float v) {
        RollerWeightSelectorButtonComponent.drawBackground(guiGraphics, screen, iAssetProvider, guiX, guiY, this.getPosX(), this.getPosY());
    }

    public void drawForegroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider iAssetProvider, int guiX, int guiY, int mouseX, int mouseY, float v) {
        RollerWeightSelectorButtonComponent.drawForeground(guiGraphics, screen, iAssetProvider, guiX, guiY, this.getPosX(), this.getPosY(), this.getWeight(), this.getYSize(), this.getType(), this.slot);
    }

    public int getPosX() {
        return (Integer)((Pair)this.inventoryComponent.getSlotPosition().apply(this.slot)).getKey() + 17;
    }

    public int getPosY() {
        return (Integer)((Pair)this.inventoryComponent.getSlotPosition().apply(this.slot)).getValue() - 1;
    }

    public int getXSize() {
        return 4;
    }

    public int getYSize() {
        return 18;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        AbstractContainerMenu abstractContainerMenu;
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AbstractContainerScreen && (abstractContainerMenu = ((AbstractContainerScreen)screen).getMenu()) instanceof ILocatable) {
            ILocatable locatable = (ILocatable)abstractContainerMenu;
            if (!this.isMouseOver(mouseX - (double)((AbstractContainerScreen)screen).getGuiLeft(), mouseY - (double)((AbstractContainerScreen)screen).getGuiTop())) {
                return false;
            }
            Minecraft.getInstance().getSoundManager().play((SoundInstance)new SimpleSoundInstance(SoundEvents.WOOD_FALL, SoundSource.PLAYERS, 0.5f, 1.0f, Minecraft.getInstance().level.getRandom(), Minecraft.getInstance().player.blockPosition()));
            CompoundTag nbt = new CompoundTag();
            nbt.putInt("WeightSlot", this.slot);
            nbt.putInt("Button", button);
            Titanium.NETWORK.sendToServer((Message)new ButtonClickNetworkMessage(locatable.getLocatorInstance(), 100, nbt));
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.getPosX() && mouseX <= (double)(this.getPosX() + this.getXSize()) && mouseY >= (double)this.getPosY() && mouseY <= (double)(this.getPosY() + this.getYSize());
    }

    public List<Component> getTooltipLines() {
        ArrayList<Component> lines = new ArrayList<Component>();
        if (this.inventoryComponent.getStackInSlot(this.slot).isEmpty()) {
            lines.add((Component)Component.literal((String)(NumberFormat.getInstance(Locale.getDefault()).format((double)(this.getWeight() + 1) / 5.0 * 100.0) + String.valueOf(ChatFormatting.DARK_AQUA) + "%" + String.valueOf(ChatFormatting.GOLD) + " " + String.valueOf(Component.translatable((String)"text.sushigocrafting.weight")))));
        } else {
            IFoodIngredient ingredient = FoodAPI.get().getIngredientFromItem(this.inventoryComponent.getStackInSlot(this.slot).getItem());
            if (!ingredient.isEmpty()) {
                String unit = ingredient.getIngredientConsumer() == IIngredientConsumer.STACK ? "u" : "gr";
                double amount = ingredient.getIngredientConsumer() == IIngredientConsumer.STACK ? (double)(ingredient.getDefaultAmount() * (this.getWeight() + 1)) : (double)(ingredient.getDefaultAmount() * (this.getWeight() + 1)) / 5.0;
                lines.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GOLD) + String.valueOf(Component.translatable((String)"text.sushigocrafting.consumes")) + String.valueOf(ChatFormatting.WHITE) + NumberFormat.getInstance(Locale.getDefault()).format(amount) + String.valueOf(ChatFormatting.YELLOW) + unit)));
            }
        }
        lines.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.DARK_GRAY) + "*" + String.valueOf(Component.translatable((String)"text.sushigocrafting.left_click_increase")) + "*")));
        lines.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.DARK_GRAY) + "*" + String.valueOf(Component.translatable((String)"text.sushigocrafting.right_click_decrease")) + "*")));
        return lines;
    }

    public abstract int getWeight();

    public abstract String getType();
}

