/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.item;

import com.buuz135.sushigocrafting.api.IFoodIngredient;
import com.buuz135.sushigocrafting.api.IFoodType;
import com.buuz135.sushigocrafting.api.IIngredientEffect;
import com.buuz135.sushigocrafting.api.impl.FoodAPI;
import com.buuz135.sushigocrafting.api.impl.effect.ModifyIngredientEffect;
import com.buuz135.sushigocrafting.item.SushiDataComponent;
import com.buuz135.sushigocrafting.item.SushiItem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FoodItem
extends SushiItem {
    public static final String WEIGHTS_TAG = "Weights";
    public static final String SPICES_TAG = "Spices";
    private final List<IFoodIngredient> ingredientList;
    private final IFoodType type;

    public FoodItem(Item.Properties properties, IFoodType type) {
        super(properties.food(new FoodProperties.Builder().build()), type.getName());
        this.type = type;
        this.ingredientList = new ArrayList<IFoodIngredient>();
    }

    public static String getWeightText(int weight) {
        if (weight < 0) {
            return String.valueOf(weight == -1 ? ChatFormatting.RED : ChatFormatting.DARK_RED) + "\u25be";
        }
        if (weight > 0) {
            return String.valueOf(weight == 1 ? ChatFormatting.RED : ChatFormatting.DARK_RED) + "\u25b4";
        }
        return String.valueOf(ChatFormatting.GOLD) + "\uff65";
    }

    public static List<Component> getTagsFrom(int negative, int positive) {
        ArrayList<Component> names = new ArrayList<Component>();
        if (negative == 0 && positive == 0) {
            names.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GOLD) + Component.translatable((String)"text.sushigocrafting.perfect").getString())));
        } else if (Math.abs(negative) == positive) {
            names.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.DARK_GREEN) + Component.translatable((String)"text.sushigocrafting.weirdly_balanced").getString())));
        }
        if (Math.abs(negative) < positive) {
            names.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + Component.translatable((String)"text.sushigocrafting.almost_hollow").getString())));
        }
        if (Math.abs(negative) > positive) {
            names.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + Component.translatable((String)"text.sushigocrafting.overflowing").getString())));
        }
        return names;
    }

    public static ModifyIngredientEffect getModifierFrom(int negative, int positive) {
        if (negative == 0 && positive == 0) {
            return new ModifyIngredientEffect(2.0f, 1);
        }
        if (Math.abs(negative) == positive) {
            return new ModifyIngredientEffect(1.2f, 0);
        }
        if (Math.abs(negative) < positive) {
            return new ModifyIngredientEffect(0.8f, 0);
        }
        if (Math.abs(negative) > positive) {
            return new ModifyIngredientEffect(0.8f, 0);
        }
        return new ModifyIngredientEffect(1.0f, 0);
    }

    public static float getFoodModifierValue(int negative, int positive) {
        if (negative == 0 && positive == 0) {
            return 1.25f;
        }
        if (Math.abs(negative) == positive) {
            return 0.9f;
        }
        return 0.8f;
    }

    public List<IFoodIngredient> getIngredientList() {
        return this.ingredientList;
    }

    public IFoodType getType() {
        return this.type;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
        tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + Component.translatable((String)"itemGroup.ingredients").getString() + ": ")));
        for (int i = 0; i < this.ingredientList.size(); ++i) {
            if (this.ingredientList.get(i).isEmpty()) continue;
            Object line = String.valueOf(ChatFormatting.GRAY) + " - " + Component.translatable((String)this.ingredientList.get(i).getItem().getDescriptionId()).getString();
            if (stack.has(SushiDataComponent.FOOD_WEIGHTS)) {
                line = (String)line + " " + FoodItem.getWeightText((Integer)((List)stack.get(SushiDataComponent.FOOD_WEIGHTS)).get(i));
            }
            tooltip.add((Component)Component.literal((String)line));
        }
        if (stack.has(SushiDataComponent.FOOD_SPICES)) {
            CompoundTag compoundNBT = (CompoundTag)stack.get(SushiDataComponent.FOOD_SPICES);
            for (String name : compoundNBT.getAllKeys()) {
                IFoodIngredient foodIngredient = FoodAPI.get().getIngredientFromName(name);
                if (foodIngredient.isEmpty()) continue;
                tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + " - " + Component.translatable((String)foodIngredient.getItem().getDescriptionId()).getString())));
            }
        }
        boolean hasShift = Screen.hasShiftDown();
        boolean hasAlt = Screen.hasAltDown();
        Info info = new Info(stack, hasShift);
        tooltip.addAll(FoodItem.getTagsFrom(info.getNegative(), info.getPositive()));
        tooltip.add((Component)Component.literal((String)""));
        if (hasShift) {
            if (info.getEffectInstances().size() > 0) {
                tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.DARK_AQUA) + Component.translatable((String)"text.sushigocrafting.effects").getString() + ":")));
                if (hasAlt) {
                    tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + " - " + String.valueOf(ChatFormatting.GOLD) + Component.translatable((String)"text.sushigocrafting.hunger").getString() + ": " + String.valueOf(ChatFormatting.WHITE) + (int)info.getHunger())));
                    tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + " - " + String.valueOf(ChatFormatting.GOLD) + Component.translatable((String)"text.sushigocrafting.saturation").getString() + ": " + String.valueOf(ChatFormatting.WHITE) + info.getSaturation())));
                }
                info.getEffectInstances().forEach(effectInstance -> tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + " - " + String.valueOf(ChatFormatting.GOLD) + Component.translatable((String)effectInstance.getDescriptionId()).getString() + String.valueOf(ChatFormatting.DARK_AQUA) + " (" + String.valueOf(ChatFormatting.WHITE) + effectInstance.getDuration() / 20 + String.valueOf(ChatFormatting.YELLOW) + "s" + String.valueOf(ChatFormatting.DARK_AQUA) + ", " + String.valueOf(ChatFormatting.YELLOW) + "Level " + String.valueOf(ChatFormatting.WHITE) + (effectInstance.getAmplifier() + 1) + String.valueOf(ChatFormatting.DARK_AQUA) + ")"))));
            }
        } else {
            tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + Component.translatable((String)"text.sushigocrafting.hold").getString() + String.valueOf(ChatFormatting.GOLD) + " " + String.valueOf(ChatFormatting.ITALIC) + "<" + Component.translatable((String)"key.keyboard.left.shift").getString() + ">" + String.valueOf(ChatFormatting.RESET) + String.valueOf(ChatFormatting.YELLOW) + Component.translatable((String)"text.sushigocrafting.sushi_effect").getString())));
        }
    }

    public ItemStack finishUsingItem(ItemStack stack, Level worldIn, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Info info = new Info(stack, true);
            player.getFoodData().eat((int)info.getHunger(), info.getSaturation());
            info.getEffectInstances().forEach(arg_0 -> ((Player)player).addEffect(arg_0));
            worldIn.playSound(null, entity.getX(), entity.getY(), entity.getZ(), entity.getEatingSound(stack), SoundSource.NEUTRAL, 1.0f, 1.0f + (worldIn.random.nextFloat() - worldIn.random.nextFloat()) * 0.4f);
            if (!(entity instanceof Player) || !((Player)entity).getAbilities().instabuild) {
                stack.shrink(1);
            }
            return stack;
        }
        return entity.eat(worldIn, stack);
    }

    @Nullable
    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        Info info = new Info(stack, true);
        return new FoodProperties.Builder().nutrition((int)Math.floor(info.getHunger())).saturationModifier(info.getSaturation()).build();
    }

    public static class Info {
        private final ItemStack stack;
        private final List<MobEffectInstance> effectInstances;
        private final float saturation;
        private final float hunger;
        private ModifyIngredientEffect modifyIngredientEffect;
        private int positive;
        private int negative = 0;

        public Info(ItemStack stack, boolean calculateEffects) {
            this.stack = stack;
            this.effectInstances = new ArrayList<MobEffectInstance>();
            this.modifyIngredientEffect = null;
            if (stack.has(SushiDataComponent.FOOD_WEIGHTS)) {
                Iterator iterator = ((List)stack.get(SushiDataComponent.FOOD_WEIGHTS)).iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    if (i < 0) {
                        this.negative += i;
                    }
                    if (i <= 0) continue;
                    this.positive += i;
                }
                this.modifyIngredientEffect = FoodItem.getModifierFrom(this.negative, this.positive);
            }
            FoodItem foodItem = (FoodItem)stack.getItem();
            this.hunger = (float)foodItem.getIngredientList().stream().map(IFoodIngredient::getHungerValue).mapToInt(Integer::intValue).sum() * FoodItem.getFoodModifierValue(this.negative, this.positive);
            this.saturation = (float)foodItem.getIngredientList().stream().map(IFoodIngredient::getSaturationValue).mapToInt(Integer::intValue).sum() * FoodItem.getFoodModifierValue(this.negative, this.positive) / (float)(foodItem.ingredientList.size() + 2);
            if (calculateEffects) {
                ArrayList<IFoodIngredient> foodIngredients = new ArrayList<IFoodIngredient>(foodItem.getIngredientList());
                if (stack.has(SushiDataComponent.FOOD_SPICES)) {
                    CompoundTag compoundNBT = (CompoundTag)stack.get(SushiDataComponent.FOOD_SPICES);
                    for (String name : compoundNBT.getAllKeys()) {
                        IFoodIngredient foodIngredient = FoodAPI.get().getIngredientFromName(name);
                        if (foodIngredient.isEmpty()) continue;
                        foodIngredients.add(foodIngredient);
                    }
                }
                foodIngredients.stream().map(IFoodIngredient::getEffect).filter(Objects::nonNull).sorted(Comparator.comparingInt(IIngredientEffect::getPriority)).forEach(iIngredientEffect -> iIngredientEffect.accept(this.effectInstances));
                if (this.modifyIngredientEffect != null) {
                    this.modifyIngredientEffect.accept(this.effectInstances);
                }
            }
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public List<MobEffectInstance> getEffectInstances() {
            return this.effectInstances;
        }

        public ModifyIngredientEffect getModifyIngredientEffect() {
            return this.modifyIngredientEffect;
        }

        public int getPositive() {
            return this.positive;
        }

        public int getNegative() {
            return this.negative;
        }

        public float getSaturation() {
            return this.saturation;
        }

        public float getHunger() {
            return this.hunger;
        }
    }
}

