/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.book.component;

import cn.leolezury.eternalstarlight.common.client.book.BookContext;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponent;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponentConfig;
import cn.leolezury.eternalstarlight.common.client.book.text.BookContent;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MobInfoBookComponent
extends BookComponent<Config> {
    private static final Object2IntMap<ResourceLocation> SELECTED_INDEX = new Object2IntArrayMap();
    private static final Map<EntityType<?>, Entity> CACHED_ENTITY_SAMPLES = new HashMap();

    public MobInfoBookComponent() {
        super(Config.CODEC);
    }

    @Override
    public int getTotalHeight(Config config, BookContext context) {
        return config.height();
    }

    @Override
    public void render(Config config, BookContext context, GuiGraphics graphics, int x, int y) {
        if (config.entries().isEmpty()) {
            return;
        }
        int selectedIndex = Mth.clamp((int)SELECTED_INDEX.getOrDefault((Object)config.id(), 0), (int)0, (int)(config.entries().size() - 1));
        int centerY = y + config.height() / 2;
        graphics.blit(config.leftButton(), x + config.centerX() - config.width() / 2, centerY - config.buttonHeight() / 2, 0.0f, 0.0f, config.buttonWidth(), config.buttonHeight(), config.buttonWidth(), config.buttonHeight());
        graphics.blit(config.rightButton(), x + config.centerX() + config.width() / 2 - config.buttonWidth(), centerY - config.buttonHeight() / 2, 0.0f, 0.0f, config.buttonWidth(), config.buttonHeight(), config.buttonWidth(), config.buttonHeight());
        Entry entry = config.entries().get(selectedIndex);
        graphics.blit(entry.icon(), x + config.centerX() - entry.iconWidth() / 2, centerY - entry.iconHeight() / 2, 0.0f, 0.0f, entry.iconWidth(), entry.iconHeight(), entry.iconWidth(), entry.iconHeight());
    }

    @Override
    public void renderDelayed(Config config, BookContext context, GuiGraphics graphics, int x, int y) {
        if (config.entries().isEmpty()) {
            return;
        }
        int selectedIndex = Mth.clamp((int)SELECTED_INDEX.getOrDefault((Object)config.id(), 0), (int)0, (int)(config.entries().size() - 1));
        int centerY = y + config.height() / 2;
        Entry entry = config.entries().get(selectedIndex);
        if (context.getMouseX() >= x + config.centerX() - entry.iconWidth() / 2 && context.getMouseX() <= x + config.centerX() + entry.iconWidth() / 2 && context.getMouseY() >= Math.max(centerY - entry.iconHeight() / 2, context.getContentY()) && context.getMouseY() <= Math.min(centerY + entry.iconHeight() / 2, context.getContentY() + context.getBookDefinition().height() - 2 * context.getBookDefinition().frameWidth())) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            if (entry.attribute().isPresent()) {
                LivingEntity living;
                AttributeInstance instance;
                Entity entity;
                Optional entityType = BuiltInRegistries.ENTITY_TYPE.getOptional(config.mob());
                Optional attribute = BuiltInRegistries.ATTRIBUTE.getHolder(entry.attribute().get());
                if (entityType.isPresent() && attribute.isPresent() && Minecraft.getInstance().level != null && (entity = CACHED_ENTITY_SAMPLES.computeIfAbsent((EntityType)entityType.get(), type -> type.create((Level)Minecraft.getInstance().level))) instanceof LivingEntity && (instance = (living = (LivingEntity)entity).getAttribute((Holder)attribute.get())) != null && entry.attributeTextStyle().isPresent()) {
                    tooltip.add(Component.translatable((String)((Attribute)((Holder.Reference)attribute.get()).value()).getDescriptionId()).append(": " + ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(instance.getValue())).withStyle(entry.attributeTextStyle().get()));
                    if (!entry.text().toComponent().getString().isEmpty()) {
                        tooltip.add(Component.empty());
                    }
                }
            }
            if (!entry.text().toComponent().getString().isEmpty()) {
                List list = context.getFont().split((FormattedText)entry.text().toComponent(), config.tooltipWidth());
                list.forEach(s -> tooltip.add((MutableComponent)new Component(){
                    final /* synthetic */ FormattedCharSequence val$s;
                    {
                        this.val$s = formattedCharSequence;
                    }

                    public Style getStyle() {
                        return Style.EMPTY;
                    }

                    public ComponentContents getContents() {
                        return PlainTextContents.EMPTY;
                    }

                    public List<Component> getSiblings() {
                        return List.of();
                    }

                    public FormattedCharSequence getVisualOrderText() {
                        return this.val$s;
                    }
                }));
            }
            graphics.pose().pushPose();
            graphics.pose().translate(0.0, 0.0, 790.0);
            graphics.renderTooltip(context.getFont(), tooltip, Optional.empty(), context.getMouseX(), context.getMouseY());
            graphics.pose().popPose();
        }
    }

    @Override
    public void onClick(Config config, BookContext context, int x, int y) {
        if (config.entries().isEmpty()) {
            return;
        }
        int selectedIndex = Mth.clamp((int)SELECTED_INDEX.getOrDefault((Object)config.id(), 0), (int)0, (int)(config.entries().size() - 1));
        int leftButtonX = x + config.centerX() - config.width() / 2;
        int rightButtonX = x + config.centerX() + config.width() / 2 - config.buttonWidth();
        int buttonY = y + config.height() / 2 - config.buttonHeight() / 2;
        if (context.getMouseX() >= leftButtonX && context.getMouseX() <= leftButtonX + config.buttonWidth() && context.getMouseY() >= buttonY && context.getMouseY() <= buttonY + config.buttonHeight()) {
            SELECTED_INDEX.put((Object)config.id(), Mth.clamp((int)(selectedIndex - 1), (int)0, (int)(config.entries().size() - 1)));
        }
        if (context.getMouseX() >= rightButtonX && context.getMouseX() <= rightButtonX + config.buttonWidth() && context.getMouseY() >= buttonY && context.getMouseY() < buttonY + config.buttonHeight()) {
            SELECTED_INDEX.put((Object)config.id(), Mth.clamp((int)(selectedIndex + 1), (int)0, (int)(config.entries().size() - 1)));
        }
    }

    public record Config(ResourceLocation id, HashSet<HashSet<ResourceLocation>> unlockConditions, ResourceLocation mob, List<Entry> entries, int tooltipWidth, int centerX, int width, int height, int buttonWidth, int buttonHeight, ResourceLocation leftButton, ResourceLocation rightButton) implements BookComponentConfig
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(Config::id), (App)ResourceLocation.CODEC.listOf().xmap(Sets::newHashSet, Lists::newArrayList).listOf().xmap(Sets::newHashSet, Lists::newArrayList).fieldOf("unlock_conditions").forGetter(Config::unlockConditions), (App)ResourceLocation.CODEC.fieldOf("mob").forGetter(Config::mob), (App)Entry.CODEC.listOf().fieldOf("entries").forGetter(Config::entries), (App)Codec.INT.fieldOf("tooltip_width").forGetter(Config::tooltipWidth), (App)Codec.INT.fieldOf("center_x").forGetter(Config::centerX), (App)Codec.INT.fieldOf("width").forGetter(Config::width), (App)Codec.INT.fieldOf("height").forGetter(Config::height), (App)Codec.INT.fieldOf("button_width").forGetter(Config::buttonWidth), (App)Codec.INT.fieldOf("button_height").forGetter(Config::buttonHeight), (App)ResourceLocation.CODEC.fieldOf("left_button").forGetter(Config::leftButton), (App)ResourceLocation.CODEC.fieldOf("right_button").forGetter(Config::rightButton)).apply((Applicative)instance, Config::new));
    }

    public record Entry(BookContent text, Optional<ResourceLocation> attribute, Optional<Style> attributeTextStyle, int iconWidth, int iconHeight, ResourceLocation icon) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BookContent.CODEC.fieldOf("text").forGetter(Entry::text), (App)ResourceLocation.CODEC.optionalFieldOf("attribute").forGetter(Entry::attribute), (App)Style.Serializer.CODEC.optionalFieldOf("attribute_text_style").forGetter(Entry::attributeTextStyle), (App)Codec.INT.fieldOf("icon_width").forGetter(Entry::iconWidth), (App)Codec.INT.fieldOf("icon_height").forGetter(Entry::iconHeight), (App)ResourceLocation.CODEC.fieldOf("icon").forGetter(Entry::icon)).apply((Applicative)instance, Entry::new));
    }
}

