/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.animation.AnimatedEntityModel;
import cn.leolezury.eternalstarlight.common.client.model.animation.definition.CrystallizedMothAnimation;
import cn.leolezury.eternalstarlight.common.entity.living.animal.CrystallizedMoth;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CrystallizedMothModel<T extends CrystallizedMoth>
extends AnimatedEntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("crystallized_moth"), "main");
    private final ModelPart root;

    public CrystallizedMothModel(ModelPart root) {
        this.root = root.getChild("root");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)21.0f, (float)0.0f));
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 38).addBox(-4.0f, -6.0f, -3.0f, 8.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 12).addBox(-3.0f, -5.0f, -6.0f, 6.0f, 5.0f, 13.0f, new CubeDeformation(0.0f)).texOffs(38, 24).addBox(2.0f, 0.0f, -4.0f, 0.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(38, 24).addBox(-2.0f, 0.0f, -4.0f, 0.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        root.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 18.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.5f, (float)-3.0f, (float)0.0f, (float)0.3491f, (float)0.0f));
        root.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-18.0f, 0.0f, 0.0f, 18.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-2.5f, (float)-3.0f, (float)0.0f, (float)-0.3491f, (float)0.0f));
        root.addOrReplaceChild("left_wing_small", CubeListBuilder.create().texOffs(0, 30).addBox(0.0f, -5.0f, 3.0f, 12.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)-0.0436f, (float)-0.2618f, (float)-0.0436f));
        root.addOrReplaceChild("right_wing_small", CubeListBuilder.create().texOffs(0, 30).mirror().addBox(-12.0f, -5.0f, 3.0f, 12.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)-0.0436f, (float)0.2618f, (float)0.0436f));
        root.addOrReplaceChild("left_tentacle", CubeListBuilder.create().texOffs(38, 12).addBox(-1.0f, 0.0f, -6.0f, 4.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-1.5f, (float)-6.0f, (float)-0.829f, (float)-0.3927f, (float)0.0f));
        root.addOrReplaceChild("right_tentacle", CubeListBuilder.create().texOffs(38, 12).mirror().addBox(-3.0f, 0.0f, -6.0f, 4.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)-1.5f, (float)-6.0f, (float)-0.829f, (float)0.3927f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.root.xRot += headPitch * ((float)Math.PI / 180);
        this.root.yRot += netHeadYaw * ((float)Math.PI / 180);
        if (this.young) {
            this.root.xScale = 0.6f;
            this.root.yScale = 0.6f;
            this.root.zScale = 0.6f;
        }
        this.animate(((CrystallizedMoth)((Object)entity)).idleAnimationState, CrystallizedMothAnimation.IDLE, ageInTicks);
    }

    @Override
    public ModelPart root() {
        return this.root;
    }
}

