/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.entity.living.monster.NightfallSpider;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NightfallSpiderModel<T extends NightfallSpider>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("nightfall_spider"), "main");
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightMiddleHindLeg;
    private final ModelPart leftMiddleHindLeg;
    private final ModelPart rightMiddleFrontLeg;
    private final ModelPart leftMiddleFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;

    public NightfallSpiderModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("head");
        this.rightHindLeg = root.getChild("leg1");
        this.leftHindLeg = root.getChild("leg2");
        this.rightMiddleHindLeg = root.getChild("leg3");
        this.leftMiddleHindLeg = root.getChild("leg4");
        this.rightMiddleFrontLeg = root.getChild("leg5");
        this.leftMiddleFrontLeg = root.getChild("leg6");
        this.rightFrontLeg = root.getChild("leg7");
        this.leftFrontLeg = root.getChild("leg8");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 20).addBox(-4.0f, -4.0f, -6.5f, 8.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)17.0f, (float)-3.5f));
        head.addOrReplaceChild("left_fang", CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, -6.0f, -11.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)7.0f, (float)3.5f));
        head.addOrReplaceChild("right_fang", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-3.0f, -6.0f, -11.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)7.0f, (float)3.5f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -12.0f, -1.0f, 10.0f, 9.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(30, 24).addBox(-3.0f, -10.0f, -3.0f, 6.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(23, 20).addBox(-11.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)17.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(23, 20).mirror().addBox(-1.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)17.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(23, 20).addBox(-11.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)17.0f, (float)4.0f));
        partdefinition.addOrReplaceChild("leg4", CubeListBuilder.create().texOffs(23, 20).mirror().addBox(-1.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)17.0f, (float)4.0f));
        partdefinition.addOrReplaceChild("leg5", CubeListBuilder.create().texOffs(23, 20).addBox(-11.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)17.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("leg6", CubeListBuilder.create().texOffs(23, 20).mirror().addBox(-1.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)17.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("leg7", CubeListBuilder.create().texOffs(23, 20).addBox(-11.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)17.0f, (float)-2.0f));
        partdefinition.addOrReplaceChild("leg8", CubeListBuilder.create().texOffs(23, 20).mirror().addBox(-1.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)3.0f, (float)17.0f, (float)-2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.rightHindLeg.zRot = -0.7853982f;
        this.leftHindLeg.zRot = 0.7853982f;
        this.rightMiddleHindLeg.zRot = -0.58119464f;
        this.leftMiddleHindLeg.zRot = 0.58119464f;
        this.rightMiddleFrontLeg.zRot = -0.58119464f;
        this.leftMiddleFrontLeg.zRot = 0.58119464f;
        this.rightFrontLeg.zRot = -0.7853982f;
        this.leftFrontLeg.zRot = 0.7853982f;
        this.rightHindLeg.yRot = 0.7853982f;
        this.leftHindLeg.yRot = -0.7853982f;
        this.rightMiddleHindLeg.yRot = 0.3926991f;
        this.leftMiddleHindLeg.yRot = -0.3926991f;
        this.rightMiddleFrontLeg.yRot = -0.3926991f;
        this.leftMiddleFrontLeg.yRot = 0.3926991f;
        this.rightFrontLeg.yRot = -0.7853982f;
        this.leftFrontLeg.yRot = 0.7853982f;
        float n = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + 0.0f)) * 0.4f) * limbSwingAmount;
        float o = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + (float)Math.PI)) * 0.4f) * limbSwingAmount;
        float p = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + 1.5707964f)) * 0.4f) * limbSwingAmount;
        float q = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + 4.712389f)) * 0.4f) * limbSwingAmount;
        float r = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + 0.0f)) * 0.4f) * limbSwingAmount;
        float s = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.4f) * limbSwingAmount;
        float t = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + 1.5707964f)) * 0.4f) * limbSwingAmount;
        float u = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + 4.712389f)) * 0.4f) * limbSwingAmount;
        ModelPart leg = this.rightHindLeg;
        leg.yRot += n;
        leg = this.leftHindLeg;
        leg.yRot += -n;
        leg = this.rightMiddleHindLeg;
        leg.yRot += o;
        leg = this.leftMiddleHindLeg;
        leg.yRot += -o;
        leg = this.rightMiddleFrontLeg;
        leg.yRot += p;
        leg = this.leftMiddleFrontLeg;
        leg.yRot += -p;
        leg = this.rightFrontLeg;
        leg.yRot += q;
        leg = this.leftFrontLeg;
        leg.yRot += -q;
        leg = this.rightHindLeg;
        leg.zRot += r;
        leg = this.leftHindLeg;
        leg.zRot += -r;
        leg = this.rightMiddleHindLeg;
        leg.zRot += s;
        leg = this.leftMiddleHindLeg;
        leg.zRot += -s;
        leg = this.rightMiddleFrontLeg;
        leg.zRot += t;
        leg = this.leftMiddleFrontLeg;
        leg.zRot += -t;
        leg = this.rightFrontLeg;
        leg.zRot += u;
        leg = this.leftFrontLeg;
        leg.zRot += -u;
    }
}

