/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.particle.effect;

import cn.leolezury.eternalstarlight.common.client.ESRenderType;
import cn.leolezury.eternalstarlight.common.client.handler.ClientHandlers;
import cn.leolezury.eternalstarlight.common.particle.ESSmokeParticleOptions;
import cn.leolezury.eternalstarlight.common.util.Color;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ESSmokeParticle
extends SimpleAnimatedParticle {
    private final float rotSpeed;

    protected ESSmokeParticle(ClientLevel level, float lifeMultiplier, double x, double y, double z, double dx, double dy, double dz, boolean rise, double movementMultiplier, int fromColor, int toColor, float alpha, SpriteSet spriteSet, float gravity) {
        super(level, x, y, z, spriteSet, gravity);
        this.xd = dx + (Math.random() * 2.0 - 1.0) * (double)0.4f;
        this.yd = dy + (Math.random() * 2.0 - 1.0) * (double)0.4f;
        this.zd = dz + (Math.random() * 2.0 - 1.0) * (double)0.4f;
        double j = (Math.random() + Math.random() + 1.0) * (double)0.15f * movementMultiplier;
        double k = Math.sqrt(this.xd * this.xd + this.yd * this.yd + this.zd * this.zd);
        this.xd = this.xd / k * j * (double)0.4f;
        this.yd = this.yd / k * j * (double)0.4f + (rise ? (double)0.1f : 0.0);
        this.zd = this.zd / k * j * (double)0.4f;
        this.rotSpeed = (float)(Math.random() * (double)0.05f + (double)0.075f);
        this.lifetime = (int)((float)((int)(Math.random() * 20.0) + 40) * lifeMultiplier);
        this.quadSize *= 5.0f;
        this.alpha = alpha;
        this.friction = 1.0f;
        this.setColor(fromColor);
        this.setFadeColor(toColor);
        this.setSpriteFromAge(spriteSet);
    }

    public void tick() {
        super.tick();
        this.oRoll = this.roll;
        this.roll += this.rotSpeed;
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float f) {
        super.render(ClientHandlers.DELAYED_BUFFER_SOURCE.getBuffer(ESRenderType.PARTICLE), camera, f);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public static class Provider
    implements ParticleProvider<ESSmokeParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(ESSmokeParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ESSmokeParticle(level, options.lifeScale(), x, y, z, xSpeed, ySpeed, zSpeed, options.rise(), options.motionScale(), Color.rgbd(options.fromColor().x / 255.0f, options.fromColor().y / 255.0f, options.fromColor().z / 255.0f).rgb(), Color.rgbd(options.toColor().x / 255.0f, options.toColor().y / 255.0f, options.toColor().z / 255.0f).rgb(), options.alpha(), this.sprites, 0.0f);
        }
    }
}

