/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.particle.effect;

import cn.leolezury.eternalstarlight.common.client.ESRenderType;
import cn.leolezury.eternalstarlight.common.client.handler.ClientHandlers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ElectricSparkParticle
extends TextureSheetParticle {
    private final Vec3 destPos;
    private final List<Vec3> segments = new ArrayList<Vec3>();

    protected ElectricSparkParticle(ClientLevel clientLevel, double x, double y, double z, double dx, double dy, double dz, SpriteSet spriteSet) {
        super(clientLevel, x, y, z);
        this.stoppedByCollision = true;
        this.lifetime = (int)(this.random.nextFloat() * 7.0f + 7.0f);
        this.destPos = new Vec3(x + dx, y + dy, z + dz);
        this.pickSprite(spriteSet);
    }

    public void move(double d, double e, double f) {
        super.move(d, e, f);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTick) {
        double currentX = Mth.lerp((double)partialTick, (double)this.xo, (double)this.x);
        double currentY = Mth.lerp((double)partialTick, (double)this.yo, (double)this.y);
        double currentZ = Mth.lerp((double)partialTick, (double)this.zo, (double)this.z);
        Vec3 currentPos = new Vec3(currentX, currentY, currentZ);
        if (this.segments.isEmpty() || this.age % 3 == 0) {
            this.segments.clear();
            int numSegments = (int)(this.random.nextFloat() * 3.0f + 3.0f);
            float segmentLength = (float)(this.destPos.subtract(currentPos).length() / (double)numSegments);
            Vec3 increment = this.destPos.subtract(currentPos).scale(1.0 / (double)numSegments);
            this.segments.add(currentPos);
            for (int i = 0; i < numSegments; ++i) {
                this.segments.add(currentPos.add(increment.scale((double)(i + 1))).add(new Vec3(this.random.nextDouble() - 0.5, this.random.nextDouble() - 0.5, this.random.nextDouble() - 0.5).normalize().scale((double)(segmentLength / 2.0f))));
            }
        }
        Vec3 camPos = camera.getPosition();
        PoseStack stack = new PoseStack();
        stack.pushPose();
        stack.translate(-camPos.x, -camPos.y, -camPos.z);
        Vec3 sight = camPos.subtract(currentX, currentY, currentZ).scale(-1.0);
        VertexConsumer vertexConsumer = ClientHandlers.DELAYED_BUFFER_SOURCE.getBuffer(ESRenderType.GLOW_PARTICLE);
        for (int i = 0; i < this.segments.size() - 1; ++i) {
            Vec3 start = this.segments.get(i);
            Vec3 end = this.segments.get(i + 1);
            Vec3 offset = end.subtract(start);
            Vec3 sideOffset = offset.cross(sight).normalize().scale(0.03);
            PoseStack.Pose pose = stack.last();
            float u0 = this.getU0();
            float u1 = this.getU1();
            float v0 = this.getV0();
            float v1 = this.getV1();
            vertexConsumer.addVertex(pose, start.add(sideOffset).toVector3f()).setColor(0.6f, 0.6f, 0.9f, 0.75f).setUv(u0, v0).setLight(0xF000F0);
            vertexConsumer.addVertex(pose, start.add(sideOffset.scale(-1.0)).toVector3f()).setColor(0.6f, 0.6f, 0.9f, 0.75f).setUv(u0, v1).setLight(0xF000F0);
            vertexConsumer.addVertex(pose, end.add(sideOffset.scale(-1.0)).toVector3f()).setColor(0.6f, 0.6f, 0.9f, 0.75f).setUv(u1, v1).setLight(0xF000F0);
            vertexConsumer.addVertex(pose, end.add(sideOffset).toVector3f()).setColor(0.6f, 0.6f, 0.9f, 0.75f).setUv(u1, v0).setLight(0xF000F0);
        }
        stack.popPose();
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType options, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new ElectricSparkParticle(level, x, y, z, dx, dy, dz, this.sprites);
        }
    }
}

