/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.entity.attack.TangledHusk;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class TangledHuskRenderer
extends EntityRenderer<TangledHusk> {
    private final EntityRenderDispatcher entityRenderer;

    public TangledHuskRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.entityRenderer = context.getEntityRenderDispatcher();
    }

    public void render(TangledHusk entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        Entity entity2 = entity.level().getEntity(entity.getOwnerId());
        if (entity2 instanceof Player) {
            Player player = (Player)entity2;
            entity2 = entity.level();
            if (entity2 instanceof ClientLevel) {
                ClientLevel clientLevel = (ClientLevel)entity2;
                if (entity.cachedPlayerDisplay == null || !entity.cachedPlayerDisplay.getGameProfile().equals((Object)player.getGameProfile())) {
                    RemotePlayer remotePlayer = new RemotePlayer(clientLevel, player.getGameProfile());
                    for (EquipmentSlot slot : EquipmentSlot.values()) {
                        remotePlayer.setItemSlot(slot, player.getItemBySlot(slot).copy());
                    }
                    ESDataAttachments.HUSK_OWNER_ID.setData((Entity)remotePlayer, entity.getOwnerId());
                    entity.cachedPlayerDisplay = remotePlayer;
                }
                if (entity.cachedPlayerDisplay != null) {
                    poseStack.pushPose();
                    poseStack.mulPose(new Quaternionf().rotateY((float)((double)(-entityYaw) + Math.cos((double)entity.tickCount * 3.25) * Math.PI * (0.4 + (double)entity.getSpawnedTicks() * 0.005)) * ((float)Math.PI / 180)));
                    float swell = Mth.clamp((float)(((float)entity.getSpawnedTicks() + partialTicks) / 100.0f), (float)0.0f, (float)1.0f);
                    float factor = 1.0f + Mth.sin((float)(swell * 300.0f)) * swell * 0.01f;
                    swell = Mth.clamp((float)swell, (float)0.0f, (float)1.0f);
                    swell *= swell;
                    swell *= swell;
                    float xz = (1.0f + swell * 0.4f) * factor;
                    float y = (1.0f + swell * 0.1f) / factor;
                    poseStack.scale(xz, y, xz);
                    this.entityRenderer.render((Entity)entity.cachedPlayerDisplay, 0.0, 0.0, 0.0, 0.0f, partialTicks, poseStack, buffer, packedLight);
                    poseStack.popPose();
                }
            }
        }
    }

    public ResourceLocation getTextureLocation(TangledHusk entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

