/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.visual;

import cn.leolezury.eternalstarlight.common.util.Easing;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScreenShake {
    private final ResourceLocation dimension;
    private final Vec3 pos;
    private final float radius;
    private final int duration;
    private final float horizontalPower;
    private final float verticalPower;
    private final float horizontalFreq;
    private final float verticalFreq;
    private Easing fadeEasing = Easing.IN_QUART;
    private int age;

    public ScreenShake(ResourceLocation dimension, Vec3 pos, float radius, int duration, float horizontalPower, float verticalPower, float horizontalFreq, float verticalFreq) {
        this.dimension = dimension;
        this.pos = pos;
        this.radius = radius;
        this.duration = duration;
        this.horizontalPower = horizontalPower;
        this.verticalPower = verticalPower;
        this.horizontalFreq = horizontalFreq;
        this.verticalFreq = verticalFreq;
    }

    public void setFadeEasing(Easing fadeEasing) {
        this.fadeEasing = fadeEasing;
    }

    public void tick() {
        ++this.age;
    }

    public boolean shouldRemove() {
        return this.age > this.duration;
    }

    private float getPowerScale(float partialTicks) {
        float progress = Math.min(((float)this.age + partialTicks) / (float)this.duration, 1.0f);
        return this.fadeEasing.interpolate(progress, 1.0f, 0.0f);
    }

    public float getYawOffset() {
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        LocalPlayer player = Minecraft.getInstance().player;
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(Minecraft.getInstance().level != null && Minecraft.getInstance().level.tickRateManager().runsNormally());
        float time = player != null ? (float)player.tickCount + partialTicks : 0.0f;
        float distance = (float)this.pos.distanceTo(camera.getPosition());
        if (distance > this.radius || player != null && !player.level().dimension().location().equals((Object)this.dimension)) {
            return 0.0f;
        }
        float powerScale = this.getPowerScale(partialTicks) * (1.0f - distance / this.radius);
        float power = this.horizontalPower * powerScale;
        return (float)(Math.sin(time * this.horizontalFreq) * (double)power);
    }

    public float getPitchOffset() {
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        LocalPlayer player = Minecraft.getInstance().player;
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(Minecraft.getInstance().level != null && Minecraft.getInstance().level.tickRateManager().runsNormally());
        float time = player != null ? (float)player.tickCount + partialTicks : 0.0f;
        float distance = (float)this.pos.distanceTo(camera.getPosition());
        if (distance > this.radius || player != null && !player.level().dimension().location().equals((Object)this.dimension)) {
            return 0.0f;
        }
        float powerScale = this.getPowerScale(partialTicks) * (1.0f - distance / this.radius);
        float power = this.verticalPower * powerScale;
        return (float)(Math.sin(time * this.verticalFreq) * (double)power);
    }
}

