/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.attack;

import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.registry.ESMobEffects;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import cn.leolezury.eternalstarlight.common.util.Easing;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CrystalCluster
extends Entity
implements TraceableEntity {
    private static final String TAG_OWNER = "owner";
    private static final String TAG_SPAWNED_TICKS = "spawned_ticks";
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerId;
    protected static final EntityDataAccessor<Integer> SPAWNED_TICKS = SynchedEntityData.defineId(CrystalCluster.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public float oldClientScale = 0.0f;
    public float clientScale = 0.0f;
    public int clientCrystalType = 0;

    public LivingEntity getOwner() {
        return this.owner;
    }

    public void setOwner(LivingEntity owner) {
        this.ownerId = owner.getUUID();
        this.owner = owner;
    }

    public int getSpawnedTicks() {
        return (Integer)this.getEntityData().get(SPAWNED_TICKS);
    }

    public void setSpawnedTicks(int spawnedTicks) {
        this.getEntityData().set(SPAWNED_TICKS, (Object)spawnedTicks);
    }

    public CrystalCluster(EntityType<? extends CrystalCluster> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SPAWNED_TICKS, (Object)0);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.owner == null && this.ownerId != null) {
                    Entity entity = serverLevel.getEntity(this.ownerId);
                    if (entity instanceof LivingEntity) {
                        LivingEntity livingEntity;
                        this.owner = livingEntity = (LivingEntity)entity;
                    }
                    if (this.owner == null) {
                        this.ownerId = null;
                    }
                }
            }
            if (this.getSpawnedTicks() >= 20) {
                this.discard();
            }
            if (this.getSpawnedTicks() > 5 && this.getOwner() != null) {
                for (LivingEntity livingEntity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(0.5))) {
                    if (!ESEntityUtil.shouldHarm((Entity)this.getOwner(), (Entity)livingEntity) || !livingEntity.hurt(ESDamageTypes.getIndirectEntityDamageSource(this.level(), ESDamageTypes.CRYSTAL_INFECTION, this, (Entity)this.getOwner()), 4.0f)) continue;
                    livingEntity.addEffect(new MobEffectInstance(ESMobEffects.CRYSTAL_INFECTION.asHolder(), 120));
                }
            }
            this.setSpawnedTicks(this.getSpawnedTicks() + 1);
        } else {
            float scale;
            float f = scale = this.getSpawnedTicks() <= 5 ? Easing.OUT_QUART.calculate((float)this.getSpawnedTicks() / 5.0f) : 1.0f;
            if (this.getSpawnedTicks() >= 15) {
                scale = Easing.OUT_QUART.calculate((float)(20 - this.getSpawnedTicks()) / 5.0f);
            }
            this.oldClientScale = this.clientScale;
            this.clientScale = scale;
            if (this.clientCrystalType == 0) {
                this.clientCrystalType = this.random.nextBoolean() ? 1 : 2;
            }
        }
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        if (damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            this.discard();
        }
        return false;
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        if (compoundTag.hasUUID(TAG_OWNER)) {
            this.ownerId = compoundTag.getUUID(TAG_OWNER);
        }
        this.setSpawnedTicks(compoundTag.getInt(TAG_SPAWNED_TICKS));
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        if (this.owner != null) {
            compoundTag.putUUID(TAG_OWNER, this.owner.getUUID());
        }
        compoundTag.putInt(TAG_SPAWNED_TICKS, this.getSpawnedTicks());
    }
}

