/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.goal;

import cn.leolezury.eternalstarlight.common.entity.living.npc.boarwarf.Boarwarf;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class BoarwarfTradeWithPlayerGoal
extends Goal {
    private final Boarwarf villager;

    public BoarwarfTradeWithPlayerGoal(Boarwarf villager) {
        this.villager = villager;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!this.villager.isAlive()) {
            return false;
        }
        if (this.villager.isInWater()) {
            return false;
        }
        if (!this.villager.onGround()) {
            return false;
        }
        if (this.villager.hurtMarked) {
            return false;
        }
        Player player = this.villager.getTradingPlayer();
        if (player == null) {
            return false;
        }
        if (this.villager.distanceToSqr((Entity)player) > 16.0) {
            return false;
        }
        return Boarwarf.getBoarwarfCredit(player) >= -30;
    }

    public void start() {
        this.villager.getNavigation().stop();
    }

    public void stop() {
        this.villager.setTradingPlayer(null);
    }
}

