/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.goal;

import cn.leolezury.eternalstarlight.common.entity.living.monster.LonestarSkeleton;
import cn.leolezury.eternalstarlight.common.entity.projectile.ThrownShatteredBlade;
import cn.leolezury.eternalstarlight.common.item.combat.ShatteredSwordItem;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;

public class LonestarSkeletonShootBladeGoal
extends Goal {
    private final LonestarSkeleton mob;
    private final double speedModifier;
    private final int attackIntervalMin;
    private final float attackRadiusSqr;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private boolean usingSword;
    private int usingSwordTicks;

    public LonestarSkeletonShootBladeGoal(LonestarSkeleton monster, double d, int i, float f) {
        this.mob = monster;
        this.speedModifier = d;
        this.attackIntervalMin = i;
        this.attackRadiusSqr = f * f;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.mob.getTarget() != null && this.isHoldingRemoteAttackWeapon();
    }

    protected boolean isHoldingRemoteAttackWeapon() {
        return this.mob.getMainHandItem().is(ESItems.SHATTERED_SWORD.get());
    }

    public boolean canContinueToUse() {
        return (this.canUse() || !this.mob.getNavigation().isDone()) && this.isHoldingRemoteAttackWeapon();
    }

    public void start() {
        super.start();
        this.mob.setAggressive(true);
    }

    public void stop() {
        super.stop();
        this.mob.setAggressive(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.usingSword = false;
        this.usingSwordTicks = 0;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        LivingEntity livingEntity = this.mob.getTarget();
        if (livingEntity != null) {
            boolean bl2;
            double d = this.mob.distanceToSqr(livingEntity.getX(), livingEntity.getY(), livingEntity.getZ());
            boolean bl = this.mob.getSensing().hasLineOfSight((Entity)livingEntity);
            boolean bl3 = bl2 = this.seeTime > 0;
            if (bl != bl2) {
                this.seeTime = 0;
            }
            this.seeTime = bl ? ++this.seeTime : --this.seeTime;
            if (!(d > (double)this.attackRadiusSqr) && this.seeTime >= 20) {
                this.mob.getNavigation().stop();
                ++this.strafingTime;
            } else {
                this.mob.getNavigation().moveTo((Entity)livingEntity, this.speedModifier);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.mob.getRandom().nextFloat() < 0.3) {
                    boolean bl4 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.mob.getRandom().nextFloat() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (d > (double)(this.attackRadiusSqr * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (d < (double)(this.attackRadiusSqr * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.mob.getMoveControl().strafe(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                Entity var7 = this.mob.getControlledVehicle();
                if (var7 instanceof Mob) {
                    Mob mob = (Mob)var7;
                    mob.lookAt((Entity)livingEntity, 30.0f, 30.0f);
                }
                this.mob.lookAt((Entity)livingEntity, 30.0f, 30.0f);
            } else {
                this.mob.getLookControl().setLookAt((Entity)livingEntity, 30.0f, 30.0f);
            }
            if (this.usingSword) {
                ++this.usingSwordTicks;
                if (!bl && this.seeTime < -60) {
                    this.usingSword = false;
                    this.usingSwordTicks = 0;
                } else if (bl && this.usingSwordTicks >= 20) {
                    this.usingSword = false;
                    this.usingSwordTicks = 0;
                    this.mob.swing(InteractionHand.MAIN_HAND);
                    ThrownShatteredBlade blade = new ThrownShatteredBlade(this.mob.level(), (LivingEntity)this.mob, this.mob.getMainHandItem());
                    blade.shootFromRotation((Entity)this.mob, this.mob.getXRot(), this.mob.getYRot(), 0.0f, 2.5f, 1.0f);
                    this.mob.level().addFreshEntity((Entity)blade);
                    this.mob.level().playSound(null, blade.blockPosition(), (SoundEvent)SoundEvents.TRIDENT_THROW.value(), SoundSource.HOSTILE);
                    ItemStack stack = this.mob.getMainHandItem();
                    ShatteredSwordItem.setHasBlade(stack, false);
                    this.attackTime = this.attackIntervalMin;
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                this.usingSword = true;
                this.usingSwordTicks = 0;
                ItemStack stack = this.mob.getMainHandItem();
                ShatteredSwordItem.setHasBlade(stack, true);
            }
        }
    }
}

