/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.ESExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.particle.ExplosionShockParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import cn.leolezury.eternalstarlight.common.vfx.ScreenShakeVfx;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class FrozenBomb
extends ThrowableItemProjectile {
    public FrozenBomb(EntityType<? extends FrozenBomb> entityType, Level level) {
        super(entityType, level);
    }

    public FrozenBomb(Level level, LivingEntity livingEntity) {
        super(ESEntities.FROZEN_BOMB.get(), livingEntity, level);
    }

    public FrozenBomb(Level level, double x, double y, double z) {
        super(ESEntities.FROZEN_BOMB.get(), x, y, z, level);
    }

    protected void onHit(HitResult hitResult) {
        Level level;
        super.onHit(hitResult);
        if (hitResult.getType() != HitResult.Type.MISS && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), this.getY() + (double)(this.random.nextFloat() * this.getBbHeight()), this.getZ() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), 5, 0.2, 0.2, 0.2, 0.0);
            serverLevel.sendParticles((ParticleOptions)ESParticles.ASHEN_SNOW.get(), this.getX() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), this.getY() + (double)(this.random.nextFloat() * this.getBbHeight()), this.getZ() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), 5, 0.2, 0.2, 0.2, 0.0);
            for (int i = 0; i <= 10; ++i) {
                serverLevel.sendParticles((ParticleOptions)ESParticles.ORBITAL_ASHEN_SNOW.get(), this.getX() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), this.getY() + (double)((this.random.nextFloat() - 0.5f) * this.getBbHeight() * 8.0f), this.getZ() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), 5, 0.2, 1.5, 0.2, 0.0);
                ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(ExplosionShockParticleOptions.FROZEN, this.getX() + (double)((this.random.nextFloat() - 0.5f) * this.getBbWidth() * 5.0f), this.getY(), this.getZ() + (double)((this.random.nextFloat() - 0.5f) * this.getBbWidth() * 5.0f), 0.0, 1.0, 0.0));
            }
            serverLevel.sendParticles((ParticleOptions)ESParticles.BIG_EXPLOSION.get(), this.getX() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), this.getY() + (double)(this.random.nextFloat() * this.getBbHeight()), this.getZ() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), 3, 0.2, 0.2, 0.2, 0.0);
            serverLevel.sendParticles((ParticleOptions)ESExplosionParticleOptions.FROZEN, this.getX() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), this.getY() + (double)(this.random.nextFloat() * this.getBbHeight()), this.getZ() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), 10, 1.5, 1.5, 1.5, 0.0);
            this.level().explode((Entity)this, null, null, this.getX(), this.getY(), this.getZ(), 3.0f, false, Level.ExplosionInteraction.TNT, (ParticleOptions)ESExplosionParticleOptions.FROZEN, (ParticleOptions)ESExplosionParticleOptions.FROZEN, (Holder)SoundEvents.GENERIC_EXPLODE);
            for (LivingEntity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(3.0))) {
                if (!ESEntityUtil.shouldHarm(this.getOwner(), (Entity)entity)) continue;
                if (entity.canFreeze()) {
                    entity.setTicksFrozen(Math.min(entity.getTicksFrozen() + 100, 300));
                }
                entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60));
            }
            ScreenShakeVfx.createInstance((ResourceKey<Level>)this.level().dimension(), this.position(), 30.0f, 20, 0.2f, 0.24f, 4.0f, 5.0f).send(serverLevel);
            this.discard();
        }
    }

    @NotNull
    protected Item getDefaultItem() {
        return ESItems.FROZEN_BOMB.get();
    }
}

