/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.entity.living.monster.Gleech;
import cn.leolezury.eternalstarlight.common.registry.ESCriteriaTriggers;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class GleechEgg
extends ThrowableItemProjectile {
    public GleechEgg(EntityType<? extends GleechEgg> entityType, Level level) {
        super(entityType, level);
    }

    public GleechEgg(Level level, LivingEntity livingEntity) {
        super(ESEntities.GLEECH_EGG.get(), livingEntity, level);
    }

    public GleechEgg(Level level, double x, double y, double z) {
        super(ESEntities.GLEECH_EGG.get(), x, y, z, level);
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        this.discard();
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        LivingEntity livingEntity;
        Entity entity;
        super.onHitEntity(entityHitResult);
        entityHitResult.getEntity().hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
        if (!this.level().isClientSide && (entity = entityHitResult.getEntity()) instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).getType().is(ESTags.EntityTypes.GLEECH_IMMUNE)) {
            Gleech gleech;
            Entity entity2 = this.getOwner();
            if (entity2 instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity2;
                ESCriteriaTriggers.THROW_GLEECH_EGG.get().trigger(serverPlayer);
            }
            if ((gleech = (Gleech)ESEntities.GLEECH.get().create(this.level())) != null) {
                gleech.setPos(this.position());
                gleech.setLarval(true);
                gleech.attachTo(livingEntity);
                this.level().addFreshEntity((Entity)gleech);
                gleech.setTarget(livingEntity);
                gleech.hurt(this.damageSources().mobAttack(livingEntity), 0.0f);
            }
        }
    }

    @NotNull
    protected Item getDefaultItem() {
        return ESItems.GLEECH_EGG.get();
    }
}

