/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.AbstractList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public class LargeItemStackList
extends AbstractList<LargeItemStack> {
    private final List<LargeItemStack> list;

    public LargeItemStackList(List<LargeItemStack> list) {
        this.list = list;
    }

    @Override
    public LargeItemStack get(int index) {
        return this.list.get(index);
    }

    @Override
    public LargeItemStack set(int index, LargeItemStack value) {
        return this.list.set(index, value);
    }

    @Override
    public void add(int index, LargeItemStack value) {
        this.list.add(index, value);
    }

    @Override
    public LargeItemStack remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof LargeItemStackList) {
            LargeItemStackList stacks = (LargeItemStackList)other;
            if (stacks.size() != this.size()) {
                return false;
            }
            for (int i = 0; i < stacks.size(); ++i) {
                if (ItemStack.matches((ItemStack)stacks.get(i).getItem(), (ItemStack)this.get(i).getItem()) && stacks.get(i).getCount() == this.get(i).getCount()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static class LargeItemStack {
        private final ItemStack item;
        private int count;
        public static final Codec<LargeItemStack> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.SINGLE_ITEM_CODEC.fieldOf("item").forGetter(LargeItemStack::getItem), (App)Codec.INT.fieldOf("count").forGetter(LargeItemStack::getCount)).apply((Applicative)instance, LargeItemStack::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, LargeItemStack> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, LargeItemStack::getItem, (StreamCodec)ByteBufCodecs.INT, LargeItemStack::getCount, LargeItemStack::new);

        public ItemStack getItem() {
            return this.item;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public LargeItemStack(ItemStack stack) {
            this(stack.copyWithCount(1), stack.getCount());
        }

        public LargeItemStack(ItemStack item, int count) {
            this.item = item;
            this.count = count;
        }

        public boolean isEmpty() {
            return this.item.isEmpty() || this.count == 0;
        }

        public void grow(int amount) {
            this.setCount(this.getCount() + amount);
        }

        public void shrink(int amount) {
            this.grow(-amount);
        }

        public ItemStack split(int splitAmount) {
            int splitCount = Math.min(splitAmount, this.count);
            ItemStack stack = this.item.copyWithCount(splitCount);
            this.count -= splitCount;
            return stack;
        }

        public ItemStack splitMaxStack() {
            return this.split(this.item.getMaxStackSize());
        }

        public ItemStack asItemStack() {
            return this.item.copyWithCount(this.count);
        }
    }
}

