/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.recipe;

import cn.leolezury.eternalstarlight.common.registry.ESRecipeSerializers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class ToolModificationRecipe
extends CustomRecipe {
    private final Item tool;
    private final Item input;
    private final ItemStack output;

    public ToolModificationRecipe(CraftingBookCategory category, Item tool, Item input, ItemStack output) {
        super(category);
        this.tool = tool;
        this.input = input;
        this.output = output;
    }

    public boolean matches(CraftingInput recipeInput, Level level) {
        if (recipeInput.items().stream().anyMatch(stack -> !stack.isEmpty() && !stack.is(this.tool) && !stack.is(this.input))) {
            return false;
        }
        if (recipeInput.items().stream().filter(stack -> stack.is(this.tool)).count() != 1L) {
            return false;
        }
        return recipeInput.items().stream().filter(stack -> stack.is(this.input)).count() == 1L;
    }

    public ItemStack assemble(CraftingInput recipeInput, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput recipeInput) {
        NonNullList items = NonNullList.withSize((int)recipeInput.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < items.size(); ++i) {
            ItemStack remaining;
            if (!recipeInput.getItem(i).is(this.tool) || (remaining = recipeInput.getItem(i).copy()).getDamageValue() + 1 >= remaining.getMaxDamage()) continue;
            remaining.setDamageValue(remaining.getDamageValue() + 1);
            items.set(i, (Object)remaining);
        }
        return items;
    }

    public boolean canCraftInDimensions(int i, int j) {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return ESRecipeSerializers.TOOL_MODIFICATION.get();
    }

    public static class Serializer
    implements RecipeSerializer<ToolModificationRecipe> {
        private static final MapCodec<ToolModificationRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(CraftingRecipe::category), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("tool").forGetter(o -> o.tool), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("input").forGetter(o -> o.input), (App)ItemStack.OPTIONAL_CODEC.fieldOf("output").forGetter(o -> o.output)).apply((Applicative)instance, ToolModificationRecipe::new));

        public MapCodec<ToolModificationRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ToolModificationRecipe> streamCodec() {
            return new StreamCodec<RegistryFriendlyByteBuf, ToolModificationRecipe>(this){

                public ToolModificationRecipe decode(RegistryFriendlyByteBuf friendlyByteBuf) {
                    CraftingBookCategory category = (CraftingBookCategory)friendlyByteBuf.readEnum(CraftingBookCategory.class);
                    Item tool = (Item)friendlyByteBuf.readById(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).byId(arg_0));
                    Item input = (Item)friendlyByteBuf.readById(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).byId(arg_0));
                    ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)friendlyByteBuf);
                    return new ToolModificationRecipe(category, tool, input, output);
                }

                public void encode(RegistryFriendlyByteBuf friendlyByteBuf, ToolModificationRecipe recipe) {
                    friendlyByteBuf.writeEnum((Enum)recipe.category());
                    friendlyByteBuf.writeById(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getId(arg_0), (Object)recipe.tool);
                    friendlyByteBuf.writeById(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getId(arg_0), (Object)recipe.input);
                    ItemStack.STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)recipe.output);
                }
            };
        }
    }
}

