/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin;

import cn.leolezury.eternalstarlight.common.network.SyncAttachmentsPacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import cn.leolezury.eternalstarlight.common.util.ESBookUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerEntity.class})
public abstract class ServerEntityMixin {
    @Shadow
    @Final
    private Entity entity;
    @Shadow
    @Final
    private ServerLevel level;

    @Inject(method={"addPairing(Lnet/minecraft/server/level/ServerPlayer;)V"}, at={@At(value="TAIL")})
    private void addPairing(ServerPlayer serverPlayer, CallbackInfo ci) {
        ESDataAttachments.getAttachments().forEach(attachment -> {
            if (attachment.streamCodec() != null && attachment.hasData(this.entity)) {
                ESPlatform.INSTANCE.sendToClient(serverPlayer, SyncAttachmentsPacket.create(this.entity, attachment, attachment.getData(this.entity), this.level.registryAccess()));
            }
        });
        ESBookUtil.unlock(serverPlayer, BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.entity.getType()).withPrefix("entity_seen_"));
    }
}

