/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.util;

import cn.leolezury.eternalstarlight.common.crest.Crest;
import cn.leolezury.eternalstarlight.common.data.ESRegistries;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.OrbitalTrailParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ESCrestUtil {
    public static List<Crest.Instance> getCrests(Player player) {
        return ESDataAttachments.CRESTS.getData((Entity)player);
    }

    public static List<Crest.Instance> getOwnedCrests(Player player) {
        return ESDataAttachments.OWNED_CRESTS.getData((Entity)player);
    }

    public static void setCrests(Player player, List<Crest.Instance> crests) {
        ESDataAttachments.CRESTS.setData((Entity)player, crests);
    }

    public static void setOwnedCrests(Player player, List<Crest.Instance> crests) {
        ESDataAttachments.OWNED_CRESTS.setData((Entity)player, crests);
    }

    public static boolean giveCrest(Player player, Crest.Instance crest) {
        List<Crest.Instance> set = ESCrestUtil.getOwnedCrests(player);
        ArrayList<Crest.Instance> crests = new ArrayList<Crest.Instance>(set);
        for (Crest.Instance instance : crests) {
            if (!instance.crest().is(crest.crest()) || instance.level() < crest.level()) continue;
            return false;
        }
        crests.removeIf(c -> c.crest().is(crest.crest()));
        crests.add(crest);
        ESCrestUtil.setOwnedCrests(player, crests);
        return true;
    }

    public static boolean upgradeCrest(Player player, ResourceKey<Crest> key) {
        int maxLevel = 0;
        Optional holder = player.registryAccess().registryOrThrow(ESRegistries.CREST).getHolder(key);
        if (holder.isPresent()) {
            maxLevel = ((Crest)((Holder.Reference)holder.get()).value()).maxLevel();
        }
        if (ESCrestUtil.getCrestLevel(player, key) + 1 > maxLevel) {
            return false;
        }
        Optional<Crest.Instance> instance = Crest.Instance.of(player.registryAccess(), key, ESCrestUtil.getCrestLevel(player, key) + 1);
        return instance.isPresent() && ESCrestUtil.giveCrest(player, instance.get());
    }

    public static boolean removeCrest(Player player, Holder<Crest> crest) {
        ESCrestUtil.removeCrest(player, crest, false);
        return ESCrestUtil.removeCrest(player, crest, true);
    }

    public static boolean removeCrest(Player player, Holder<Crest> crest, boolean owned) {
        List<Crest.Instance> set = owned ? ESCrestUtil.getOwnedCrests(player) : ESCrestUtil.getCrests(player);
        ArrayList<Crest.Instance> crests = new ArrayList<Crest.Instance>(set);
        if (crests.stream().noneMatch(c -> c.crest().is(crest))) {
            return false;
        }
        crests.removeIf(c -> c.crest().is(crest));
        if (owned) {
            ESCrestUtil.setOwnedCrests(player, crests);
        } else {
            ESCrestUtil.setCrests(player, crests);
        }
        return true;
    }

    public static List<Crest.Instance> mergeCrests(List<Crest.Instance> first, List<Crest.Instance> second) {
        ArrayList<Crest.Instance> result = new ArrayList<Crest.Instance>(first);
        for (Crest.Instance instance : second) {
            boolean hasSame = false;
            int level = instance.level();
            for (int i = 0; i < result.size(); ++i) {
                if (!((Crest.Instance)result.get(i)).crest().is(instance.crest())) continue;
                level = Math.max(level, ((Crest.Instance)result.get(i)).level());
                result.set(i, new Crest.Instance(instance.crest(), level));
                hasSame = true;
            }
            if (hasSame) continue;
            result.add(instance);
        }
        return result;
    }

    public static int getCrestLevel(Player player, ResourceKey<Crest> key) {
        Optional crest = player.registryAccess().registryOrThrow(ESRegistries.CREST).getHolder(key);
        return crest.map(ref -> ESCrestUtil.getCrestLevel(player, (Holder<Crest>)ref)).orElse(0);
    }

    public static int getCrestLevel(Player player, Holder<Crest> crest) {
        List<Crest.Instance> set = ESCrestUtil.getOwnedCrests(player);
        for (Crest.Instance instance : set) {
            if (!instance.crest().is(crest)) continue;
            return instance.level();
        }
        return 0;
    }

    public static void tickCrests(Player player) {
        Level level;
        Holder component;
        List<Crest.Instance> ownedSet = ESCrestUtil.getOwnedCrests(player);
        List<Crest.Instance> set = ESCrestUtil.getCrests(player);
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        if (mainHand.has(ESDataComponents.CURRENT_CREST.get())) {
            component = (Holder)mainHand.get(ESDataComponents.CURRENT_CREST.get());
            if (component != null && component.isBound() && ownedSet.stream().noneMatch(c -> c.crest().is(component))) {
                mainHand.remove(ESDataComponents.CURRENT_CREST.get());
            }
        } else if (offHand.has(ESDataComponents.CURRENT_CREST.get()) && (component = (Holder)offHand.get(ESDataComponents.CURRENT_CREST.get())) != null && component.isBound() && ownedSet.stream().noneMatch(c -> c.crest().is(component))) {
            offHand.remove(ESDataComponents.CURRENT_CREST.get());
        }
        ArrayList oldActiveCrests = new ArrayList(ESDataAttachments.OLD_ACTIVE_CRESTS.getData((Entity)player));
        ArrayList activeCrests = new ArrayList();
        set.forEach(crest -> {
            boolean doEffects = false;
            if (player.hasInfiniteMaterials()) {
                doEffects = true;
            } else {
                Inventory inventory = player.getInventory();
                for (int i = 0; i < inventory.getContainerSize(); ++i) {
                    ItemStack stack = inventory.getItem(i);
                    if (!stack.is(((Crest)crest.crest().value()).type().getCrystalsTag())) continue;
                    doEffects = true;
                    if (player.tickCount % 60 != 0) break;
                    stack.hurtAndBreak(crest.level(), (LivingEntity)player, EquipmentSlot.MAINHAND);
                    break;
                }
            }
            if (doEffects) {
                activeCrests.add(crest);
                ((Crest)crest.crest().value()).effects().ifPresent(effects -> effects.forEach(mobEffect -> player.addEffect(new MobEffectInstance(mobEffect.effect(), 20, mobEffect.level() + (crest.level() - 1) * mobEffect.levelAddition()))));
                ((Crest)crest.crest().value()).attributeModifiers().ifPresent(modifiers -> modifiers.forEach(modifier -> {
                    AttributeInstance instance = player.getAttributes().getInstance(modifier.attribute());
                    if (instance != null && !instance.hasModifier(modifier.id())) {
                        instance.addPermanentModifier(modifier.getModifier(crest.level()));
                    }
                }));
            }
        });
        oldActiveCrests.removeAll(activeCrests);
        for (Crest.Instance crest2 : oldActiveCrests) {
            ((Crest)crest2.crest().value()).attributeModifiers().ifPresent(modifiers -> modifiers.forEach(modifier -> {
                AttributeInstance instance = player.getAttributes().getInstance(modifier.attribute());
                if (instance != null && instance.hasModifier(modifier.id())) {
                    instance.removeModifier(modifier.id());
                }
            }));
        }
        ESDataAttachments.OLD_ACTIVE_CRESTS.setData((Entity)player, activeCrests);
        if (!set.isEmpty() && (level = player.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player.tickCount % 100 == 0) {
                ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(OrbitalTrailParticleOptions.magic(player), player.getX(), player.getY(), player.getZ(), 0.0, 0.02, 0.0));
            }
        }
    }
}

