/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.util;

import cn.leolezury.eternalstarlight.common.entity.interfaces.SpellCaster;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import cn.leolezury.eternalstarlight.common.spell.AbstractSpell;
import cn.leolezury.eternalstarlight.common.spell.SpellCooldown;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ESSpellUtil {
    public static int getCooldown(LivingEntity entity, AbstractSpell spell) {
        Optional<SpellCooldown> cooldown;
        if (entity instanceof SpellCaster && (cooldown = ESDataAttachments.SPELL_COOLDOWNS.getData((Entity)entity).stream().filter(c -> c.getSpell() == spell).findFirst()).isPresent()) {
            return cooldown.get().getCooldown();
        }
        return 0;
    }

    public static void setCooldown(LivingEntity entity, AbstractSpell spell, int cooldown) {
        if (entity instanceof SpellCaster) {
            ArrayList<SpellCooldown> updated = new ArrayList<SpellCooldown>((Collection)ESDataAttachments.SPELL_COOLDOWNS.getData((Entity)entity));
            if (updated.stream().noneMatch(c -> c.getSpell() == spell)) {
                updated.add(new SpellCooldown(spell, cooldown));
            } else {
                updated.stream().filter(c -> c.getSpell() == spell).findFirst().ifPresent(c -> c.setCooldown(cooldown));
            }
            ESDataAttachments.SPELL_COOLDOWNS.setData((Entity)entity, updated);
        }
    }

    public static void tickSpells(LivingEntity entity) {
        if (entity instanceof SpellCaster) {
            ArrayList<SpellCooldown> updated = new ArrayList<SpellCooldown>((Collection)ESDataAttachments.SPELL_COOLDOWNS.getData((Entity)entity));
            updated.forEach(SpellCooldown::tick);
            updated.removeIf(c -> c.getCooldown() <= 0);
            ESDataAttachments.SPELL_COOLDOWNS.setData((Entity)entity, updated);
            if (!entity.level().isClientSide && ESDataAttachments.SPELL_CAST_DATA.getData((Entity)entity).hasSpell()) {
                ESDataAttachments.SPELL_CAST_DATA.setData((Entity)entity, ESDataAttachments.SPELL_CAST_DATA.getData((Entity)entity).increaseTick());
                AbstractSpell spell = ESDataAttachments.SPELL_CAST_DATA.getData((Entity)entity).spell();
                int preparationTicks = spell.spellProperties().preparationTicks();
                int spellTicks = spell.spellProperties().spellTicks();
                int useTicks = ESDataAttachments.SPELL_CAST_DATA.getData((Entity)entity).castTicks();
                if (!spell.canContinueToCast(entity, useTicks) || !ESDataAttachments.SPELL_SOURCE.getData((Entity)entity).canContinue(entity)) {
                    spell.stop(entity, useTicks - preparationTicks);
                }
                if (useTicks <= preparationTicks + spellTicks) {
                    spell.tick(entity, useTicks);
                } else {
                    spell.stop(entity, useTicks - preparationTicks);
                }
            }
        }
    }
}

