/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.feature;

import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class AbyssalCaveFeature
extends Feature<NoneFeatureConfiguration> {
    public AbyssalCaveFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        BlockPos.MutableBlockPos placePos = new BlockPos.MutableBlockPos();
        int xSize = 8 + random.nextInt(5) - 2;
        int ySize = 8 + random.nextInt(5) - 2;
        int zSize = 8 + random.nextInt(5) - 2;
        HashSet<BlockPos> hollowPositions = new HashSet<BlockPos>();
        for (int x = -xSize; x <= xSize; ++x) {
            for (int y = -ySize; y <= ySize; ++y) {
                for (int z = -zSize; z <= zSize; ++z) {
                    if (!ESMathUtil.isPointInEllipsoid(x, y, z, xSize, ySize, zSize)) continue;
                    placePos.setWithOffset((Vec3i)pos, x, y, z);
                    BlockState state = level.getBlockState((BlockPos)placePos);
                    if (state.is(ESTags.Blocks.ABYSSAL_CAVE_REPLACEABLES) || state.is(ESTags.Blocks.STARLIGHT_CARVER_REPLACEABLES) || state.getBlock() == Blocks.WATER) {
                        hollowPositions.add(placePos.immutable());
                        continue;
                    }
                    return false;
                }
            }
        }
        hollowPositions.forEach(blockPos -> this.setBlock((LevelWriter)level, (BlockPos)blockPos, Blocks.WATER.defaultBlockState()));
        return true;
    }
}

