/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.feature.tree;

import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.phys.Vec3;

public class JinglestemFeature
extends Feature<Configuration> {
    private static final List<Direction> ATTACHMENT_FACES = List.of(Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);

    public JinglestemFeature(Codec<Configuration> codec) {
        super(codec);
    }

    private void placeBlockLine(BlockPos from, BlockPos to, Consumer<BlockPos> placer) {
        List<int[]> points = ESMathUtil.getBresenham3DPoints(from.getX(), from.getY(), from.getZ(), to.getX(), to.getY(), to.getZ());
        for (int[] point : points) {
            BlockPos trunkPos = new BlockPos(point[0], point[1], point[2]);
            placer.accept(trunkPos);
        }
    }

    private void placeBranches(BlockPos pos, int num, int len, Consumer<BlockPos> placer) {
        for (int i = 0; i < num; ++i) {
            Vec3 endVec = ESMathUtil.rotationToPosition(pos.getCenter(), len, 40.0f, 360.0f / (float)num * (float)i);
            BlockPos endPos = new BlockPos((int)endVec.x, (int)endVec.y, (int)endVec.z);
            this.placeBlockLine(pos, endPos, placer);
        }
    }

    public boolean place(FeaturePlaceContext<Configuration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        ArrayList trunkPositions = new ArrayList();
        Configuration config = (Configuration)context.config();
        BlockState attachmentState = (BlockState)ESBlocks.ALGALEAVES.get().defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        int height = config.trunkHeight().sample(random);
        BlockPos topPos = pos.offset(random.nextInt(5) - 2, height, random.nextInt(5) - 2);
        this.placeBlockLine(pos, topPos, trunkPositions::add);
        int num = config.branchAmount().sample(random);
        int len = config.branchLength().sample(random);
        this.placeBranches(topPos, num, len, trunkPositions::add);
        for (BlockPos blockPos : trunkPositions) {
            if (level.getBlockState(blockPos).is(Blocks.WATER)) continue;
            return false;
        }
        for (BlockPos blockPos : trunkPositions) {
            this.setBlock((LevelWriter)level, blockPos, ESBlocks.JINGLESTEM_LOG.get().defaultBlockState());
        }
        if (config.hasLeaves()) {
            for (BlockPos blockPos : trunkPositions) {
                if (random.nextInt(10) != 0) {
                    int l = config.leavesHeight().sample(random);
                    for (int i = 1; i <= l; ++i) {
                        if (level.getBlockState(blockPos.below(i)).is(Blocks.WATER)) {
                            this.setBlock((LevelWriter)level, blockPos.below(i), ESBlocks.HANGING_ALGALEAVES_PLANT.get().defaultBlockState());
                            if (i != l) continue;
                            this.setBlock((LevelWriter)level, blockPos.below(i), ESBlocks.HANGING_ALGALEAVES.get().defaultBlockState());
                            continue;
                        }
                        if (i == 1) break;
                        this.setBlock((LevelWriter)level, blockPos.below(i - 1), ESBlocks.HANGING_ALGALEAVES.get().defaultBlockState());
                        break;
                    }
                }
                float chance = 1.25f * (float)(blockPos.getY() - pos.getY()) / (float)height;
                if (!(random.nextFloat() < chance)) continue;
                for (Direction attachDir : ATTACHMENT_FACES) {
                    BlockPos placePos = blockPos.relative(attachDir);
                    if (!level.getBlockState(placePos).is(Blocks.WATER)) continue;
                    ArrayList<Direction> possibleDirs = new ArrayList<Direction>();
                    for (Direction direction2 : Direction.values()) {
                        BlockPos relativePos = placePos.relative(direction2);
                        if (!level.getBlockState(relativePos).is((Block)ESBlocks.JINGLESTEM_LOG.get())) continue;
                        possibleDirs.add(direction2);
                    }
                    for (Direction direction2 : Direction.values()) {
                        attachmentState = possibleDirs.contains(direction2) ? (BlockState)attachmentState.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction2), (Comparable)Boolean.valueOf(random.nextBoolean())) : (BlockState)attachmentState.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction2), (Comparable)Boolean.valueOf(false));
                    }
                    BlockState finalAttachmentState = attachmentState;
                    if (!Arrays.stream(Direction.values()).anyMatch(direction -> (Boolean)finalAttachmentState.getValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction)))) continue;
                    this.setBlock((LevelWriter)level, placePos, finalAttachmentState);
                }
            }
        }
        return true;
    }

    public record Configuration(IntProvider trunkHeight, IntProvider branchAmount, IntProvider branchLength, IntProvider leavesHeight, boolean hasLeaves) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntProvider.CODEC.fieldOf("trunk_height").forGetter(Configuration::trunkHeight), (App)IntProvider.CODEC.fieldOf("branch_amount").forGetter(Configuration::branchAmount), (App)IntProvider.CODEC.fieldOf("branch_length").forGetter(Configuration::branchLength), (App)IntProvider.CODEC.fieldOf("leaves_height").forGetter(Configuration::leavesHeight), (App)Codec.BOOL.fieldOf("has_leaves").forGetter(Configuration::hasLeaves)).apply((Applicative)instance, Configuration::new));
    }
}

