/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.structure.garden;

import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.entity.living.monster.Tangled;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESStructureTypes;
import cn.leolezury.eternalstarlight.common.world.gen.structure.garden.CursedGardenMazePiece;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;

public class CursedGardenStructure
extends Structure {
    public static final MapCodec<CursedGardenStructure> CODEC = CursedGardenStructure.simpleCodec(CursedGardenStructure::new);

    public CursedGardenStructure(Structure.StructureSettings structureSettings) {
        super(structureSettings);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        return CursedGardenStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> {
            ChunkPos chunkPos = context.chunkPos();
            int x = chunkPos.getMiddleBlockX();
            int z = chunkPos.getMiddleBlockZ();
            int y = context.chunkGenerator().getFirstOccupiedHeight(x, z, Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState()) + 1;
            builder.addPiece((StructurePiece)new CursedGardenMazePiece(context.structureTemplateManager(), context.seed(), x, y, z));
        });
    }

    public void afterPlace(WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox boundingBox, ChunkPos chunkPos, PiecesContainer piecesContainer) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BoundingBox piecesBox = piecesContainer.calculateBoundingBox();
        if (ESConfig.INSTANCE.mobsConfig.tangled.canSpawn()) {
            for (int x = boundingBox.minX(); x <= boundingBox.maxX(); ++x) {
                block1: for (int z = boundingBox.minZ(); z <= boundingBox.maxZ(); ++z) {
                    for (int y = piecesBox.minY(); y <= piecesBox.maxY(); ++y) {
                        pos.set(x, y, z);
                        if (!piecesBox.isInside((Vec3i)pos) || !piecesContainer.isInsidePiece((BlockPos)pos) || !level.isEmptyBlock((BlockPos)pos) && !level.getBlockState((BlockPos)pos).is(Blocks.VINE) || !level.isEmptyBlock(pos.above()) && !level.getBlockState(pos.above()).is(Blocks.VINE) || !level.getBlockState(pos.below()).is((Block)ESBlocks.TENACIOUS_NIGHTFALL_GRASS_BLOCK.get())) continue;
                        if (random.nextInt(150) != 0) continue block1;
                        Tangled tangled = new Tangled(ESEntities.TANGLED.get(), (Level)level.getLevel());
                        tangled.setPos(pos.getBottomCenter());
                        tangled.setPersistenceRequired();
                        level.addFreshEntity((Entity)tangled);
                        continue block1;
                    }
                }
            }
        }
    }

    public StructureType<?> type() {
        return ESStructureTypes.CURSED_GARDEN.get();
    }
}

