/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.system.transformer.biome;

import cn.leolezury.eternalstarlight.common.data.ESRegistries;
import cn.leolezury.eternalstarlight.common.registry.ESDataTransformerTypes;
import cn.leolezury.eternalstarlight.common.world.gen.system.BiomeData;
import cn.leolezury.eternalstarlight.common.world.gen.system.WorldGenProvider;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.DataTransformerType;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.biome.NoiseDataTransformer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;

public class AddBiomesTransformer
extends NoiseDataTransformer {
    public static final MapCodec<AddBiomesTransformer> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.fieldOf("xz_scale").forGetter(o -> o.xzScale), (App)RegistryFileCodec.create(ESRegistries.BIOME_DATA, BiomeData.CODEC).listOf().fieldOf("land_biomes").forGetter(o -> o.landBiomes), (App)RegistryFileCodec.create(ESRegistries.BIOME_DATA, BiomeData.CODEC).listOf().fieldOf("ocean_biomes").forGetter(o -> o.oceanBiomes)).apply((Applicative)instance, AddBiomesTransformer::new));
    private boolean init = false;
    private final double xzScale;
    private final List<Holder<BiomeData>> landBiomes;
    private final List<Holder<BiomeData>> oceanBiomes;
    private final EnumMap<BiomeData.Temperature, ArrayList<Integer>> TEMPERATURE_TO_LAND_BIOME = new EnumMap(BiomeData.Temperature.class);
    private final EnumMap<BiomeData.Temperature, ArrayList<Integer>> TEMPERATURE_TO_OCEAN_BIOME = new EnumMap(BiomeData.Temperature.class);

    public AddBiomesTransformer(double xzScale, List<Holder<BiomeData>> landBiomes, List<Holder<BiomeData>> oceanBiomes) {
        this.xzScale = xzScale;
        this.landBiomes = landBiomes;
        this.oceanBiomes = oceanBiomes;
    }

    private void initBiomes(Function<BiomeData, Integer> toId, EnumMap<BiomeData.Temperature, ArrayList<Integer>> map, List<Holder<BiomeData>> biomes) {
        for (BiomeData.Temperature temperature : BiomeData.Temperature.values()) {
            map.put(temperature, new ArrayList());
        }
        for (Holder holder : biomes) {
            for (BiomeData.Temperature temperature : ((BiomeData)holder.value()).temperatures()) {
                map.get((Object)temperature).add(toId.apply((BiomeData)holder.value()));
            }
        }
    }

    private int getRandomBiome(BiomeData.Temperature temperature, boolean isOcean, Random random) {
        ArrayList<Integer> biomeList = (isOcean ? this.TEMPERATURE_TO_OCEAN_BIOME : this.TEMPERATURE_TO_LAND_BIOME).get((Object)temperature);
        return biomeList.get(random.nextInt(biomeList.size()));
    }

    @Override
    public int transform(WorldGenProvider provider, Random random, int original, int worldX, int worldZ, PerlinSimplexNoise noise) {
        double noiseVal;
        if (!this.init) {
            this.initBiomes(provider::getBiomeDataId, this.TEMPERATURE_TO_LAND_BIOME, this.landBiomes);
            this.initBiomes(provider::getBiomeDataId, this.TEMPERATURE_TO_OCEAN_BIOME, this.oceanBiomes);
            this.init = true;
        }
        BiomeData.Temperature temperature = (noiseVal = noise.getValue((double)worldX * this.xzScale, (double)worldZ * this.xzScale, false)) >= 0.6 ? BiomeData.Temperature.HOT_EXTREME : (noiseVal >= 0.2 ? BiomeData.Temperature.HOT : (noiseVal >= -0.2 ? BiomeData.Temperature.NEUTRAL : (noiseVal >= -0.6 ? BiomeData.Temperature.COLD : BiomeData.Temperature.COLD_EXTREME)));
        return this.getRandomBiome(temperature, provider.getBiomeDataById(original).isOcean(), random);
    }

    @Override
    public DataTransformerType<?> type() {
        return ESDataTransformerTypes.ADD_BIOMES.get();
    }
}

