/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.system.transformer.biome;

import cn.leolezury.eternalstarlight.common.data.ESRegistries;
import cn.leolezury.eternalstarlight.common.registry.ESDataTransformerTypes;
import cn.leolezury.eternalstarlight.common.world.gen.system.BiomeData;
import cn.leolezury.eternalstarlight.common.world.gen.system.WorldGenProvider;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.DataTransformerType;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.biome.NeighborsRelatedTransformer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import java.util.List;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.resources.RegistryFileCodec;

public class AddTransitionBiomesTransformer
extends NeighborsRelatedTransformer {
    public static final MapCodec<AddTransitionBiomesTransformer> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeWithTransition.CODEC.listOf().fieldOf("transitions").forGetter(o -> o.transitions)).apply((Applicative)instance, AddTransitionBiomesTransformer::new));
    private final List<BiomeWithTransition> transitions;
    private final Int2IntLinkedOpenHashMap idMap = new Int2IntLinkedOpenHashMap();

    public AddTransitionBiomesTransformer(List<BiomeWithTransition> transitions) {
        this.transitions = transitions;
    }

    @Override
    public int transform(WorldGenProvider provider, Random random, int original, int up, int down, int left, int right) {
        if (this.idMap.isEmpty()) {
            for (BiomeWithTransition transition : this.transitions) {
                this.idMap.put(provider.getBiomeDataId((BiomeData)transition.biome().value()), provider.getBiomeDataId((BiomeData)transition.transitionBiome().value()));
            }
        }
        IntBidirectionalIterator intBidirectionalIterator = this.idMap.keySet().iterator();
        while (intBidirectionalIterator.hasNext()) {
            int id = (Integer)intBidirectionalIterator.next();
            if (original != id || up == id && down == id && left == id && right == id) continue;
            return this.idMap.get(id);
        }
        return original;
    }

    @Override
    public DataTransformerType<?> type() {
        return ESDataTransformerTypes.ADD_TRANSITIONS.get();
    }

    public record BiomeWithTransition(Holder<BiomeData> biome, Holder<BiomeData> transitionBiome) {
        public static final Codec<BiomeWithTransition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryFileCodec.create(ESRegistries.BIOME_DATA, BiomeData.CODEC).fieldOf("biome").forGetter(BiomeWithTransition::biome), (App)RegistryFileCodec.create(ESRegistries.BIOME_DATA, BiomeData.CODEC).fieldOf("transition_biome").forGetter(BiomeWithTransition::transitionBiome)).apply((Applicative)instance, BiomeWithTransition::new));
    }
}

