/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.neoforge.datagen.provider.book;

import cn.leolezury.eternalstarlight.common.client.book.BookDefinition;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public abstract class BookDefinitionProvider
implements DataProvider {
    private static final String DIRECTORY = "eternal_starlight/books";
    protected final ExistingFileHelper.ResourceType resourceType;
    protected final PackOutput.PathProvider pathProvider;
    protected final ExistingFileHelper existingFileHelper;
    protected final CompletableFuture<HolderLookup.Provider> lookupProvider;
    protected final String modid;
    protected final Map<ResourceLocation, BookDefinition> definitions = Maps.newHashMap();

    public BookDefinitionProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, String modId, ExistingFileHelper existingFileHelper) {
        this.resourceType = new ExistingFileHelper.ResourceType(PackType.CLIENT_RESOURCES, ".json", DIRECTORY);
        this.pathProvider = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, DIRECTORY);
        this.existingFileHelper = existingFileHelper;
        this.modid = modId;
        this.lookupProvider = lookupProvider;
    }

    public CompletableFuture<?> run(CachedOutput output) {
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        return this.lookupProvider.thenCompose(provider -> {
            this.gather((HolderLookup.Provider)provider);
            ConditionalOps dynamicOps = new ConditionalOps(RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)provider), ICondition.IContext.EMPTY);
            this.definitions.forEach((arg_0, arg_1) -> this.lambda$run$3(futuresBuilder, (DynamicOps)dynamicOps, output, arg_0, arg_1));
            return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
        });
    }

    protected abstract void gather(HolderLookup.Provider var1);

    public void add(ResourceLocation id, BookDefinition definition) {
        this.definitions.put(id, definition);
    }

    public String getName() {
        return String.format("Book definitions generator for %s", this.modid);
    }

    private /* synthetic */ void lambda$run$3(ImmutableList.Builder futuresBuilder, DynamicOps dynamicOps, CachedOutput output, ResourceLocation id, BookDefinition definition) {
        Path path = this.pathProvider.json(id);
        futuresBuilder.add((Object)CompletableFuture.supplyAsync(() -> (JsonElement)BookDefinition.CODEC.encodeStart(dynamicOps, (Object)definition).getOrThrow(msg -> new RuntimeException("Failed to encode %s: %s".formatted(path, msg)))).thenComposeAsync(encoded -> DataProvider.saveStable((CachedOutput)output, (JsonElement)encoded, (Path)path)));
    }
}

