/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui;

import appeng.api.config.ActionItems;
import appeng.api.config.CopyMode;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.AEKeySlotFilter;
import appeng.client.gui.Icon;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.gui.widgets.ToggleButton;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.util.ConfigInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.pedroksl.advanced_ae.common.helpers.PortableCellWorkbenchMenuHost;
import net.pedroksl.advanced_ae.gui.PortableWorkbenchMenu;

public class PortableWorkbenchScreen
extends UpgradeableScreen<PortableWorkbenchMenu> {
    private final ToggleButton copyMode;
    private final SettingToggleButton<FuzzyMode> fuzzyMode = (SettingToggleButton)this.addToLeftToolbar((Button)new SettingToggleButton(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL, this::toggleFuzzyMode));

    public PortableWorkbenchScreen(PortableWorkbenchMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((UpgradeableMenu)menu, playerInventory, title, style);
        this.addToLeftToolbar((Button)new ActionButton(ActionItems.COG, act -> menu.partition()));
        this.addToLeftToolbar((Button)new ActionButton(ActionItems.CLOSE, act -> menu.clear()));
        this.copyMode = (ToggleButton)this.addToLeftToolbar((Button)new ToggleButton(Icon.COPY_MODE_ON, Icon.COPY_MODE_OFF, (Component)GuiText.CopyMode.text(), (Component)GuiText.CopyModeDesc.text(), act -> menu.nextWorkBenchCopyMode()));
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.copyMode.setState(((PortableWorkbenchMenu)this.menu).getCopyMode() == CopyMode.CLEAR_ON_REMOVE);
        boolean hasFuzzy = ((PortableWorkbenchMenu)this.menu).getCachedUpgrades().isInstalled((ItemLike)AEItems.FUZZY_CARD);
        this.fuzzyMode.set((Enum)((PortableWorkbenchMenu)this.menu).getFuzzyMode());
        this.fuzzyMode.setVisibility(hasFuzzy);
    }

    private void toggleFuzzyMode(SettingToggleButton<FuzzyMode> button, boolean backwards) {
        FuzzyMode fz = (FuzzyMode)button.getNextValue(backwards);
        ((PortableWorkbenchMenu)this.menu).setCellFuzzyMode(fz);
    }

    protected List<Component> getTooltipFromContainerItem(ItemStack stack) {
        ItemStack cell = ((PortableWorkbenchMenu)this.getMenu()).getWorkbenchItem();
        if (cell.isEmpty()) {
            return super.getTooltipFromContainerItem(stack);
        }
        if (cell == stack) {
            return super.getTooltipFromContainerItem(stack);
        }
        GenericStack genericStack = GenericStack.unwrapItemStack((ItemStack)stack);
        Object what = genericStack != null ? genericStack.what() : AEItemKey.of((ItemStack)stack);
        if (what == null) {
            return super.getTooltipFromContainerItem(stack);
        }
        ConfigInventory configInventory = ((PortableCellWorkbenchMenuHost)((PortableWorkbenchMenu)this.getMenu()).getHost()).getCell().getConfigInventory(cell);
        if (!configInventory.isSupportedType(what.getType())) {
            ArrayList<Component> lines = new ArrayList<Component>(super.getTooltipFromContainerItem(stack));
            lines.add((Component)GuiText.IncompatibleWithCell.text().withStyle(ChatFormatting.RED));
            return lines;
        }
        AEKeySlotFilter filter = configInventory.getFilter();
        if (filter != null) {
            boolean anySlotMatches = false;
            for (int i = 0; i < configInventory.size(); ++i) {
                if (!configInventory.isAllowedIn(i, what)) continue;
                anySlotMatches = true;
                break;
            }
            if (!anySlotMatches) {
                ArrayList<Component> lines = new ArrayList<Component>(super.getTooltipFromContainerItem(stack));
                lines.add((Component)GuiText.IncompatibleWithCell.text().withStyle(ChatFormatting.RED));
                return lines;
            }
        }
        return super.getTooltipFromContainerItem(stack);
    }
}

