/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.style.Color;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ProgressBar;
import appeng.client.gui.widgets.Scrollbar;
import appeng.core.AppEng;
import appeng.menu.AEBaseMenu;
import appeng.menu.interfaces.IProgressProvider;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.pedroksl.advanced_ae.client.AAEHotkeys;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEIcon;
import net.pedroksl.advanced_ae.client.widgets.QuantumUpgradeWidget;
import net.pedroksl.advanced_ae.client.widgets.UpgradeState;
import net.pedroksl.advanced_ae.common.definitions.AAEComponents;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.advanced_ae.gui.QuantumArmorConfigMenu;
import net.pedroksl.advanced_ae.network.packet.quantumarmor.QuantumArmorMagnetPacket;
import net.pedroksl.advanced_ae.network.packet.quantumarmor.QuantumArmorUpgradeFilterPacket;
import net.pedroksl.advanced_ae.network.packet.quantumarmor.QuantumArmorUpgradeValuePacket;
import net.pedroksl.ae2addonlib.client.Hotkeys;
import net.pedroksl.ae2addonlib.client.widgets.AddonIconButton;

public class QuantumArmorConfigScreen
extends AEBaseScreen<QuantumArmorConfigMenu> {
    private static final int LIST_ANCHOR_X = 9;
    private static final int LIST_ANCHOR_Y = 32;
    private static final int LIST_LINE_HEIGHT = 16;
    private static final int VISIBLE_ROWS = 4;
    private static final Rect2i LIST_BACK_BBOX = new Rect2i(0, 195, 128, 16);
    private static final ResourceLocation DEFAULT_TEXTURE = AppEng.makeId((String)"textures/guis/quantum_armor_config.png");
    private final Scrollbar scrollbar;
    private final ProgressBar pb;
    private final PaletteButton paletteButton;
    private int selectedIndex = -1;
    private final List<QuantumUpgradeWidget> upgradeList = new ArrayList<QuantumUpgradeWidget>();

    public QuantumArmorConfigScreen(QuantumArmorConfigMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((AEBaseMenu)menu, playerInventory, title, style);
        this.scrollbar = this.widgets.addScrollBar("scrollbar", Scrollbar.SMALL);
        this.pb = new ProgressBar((IProgressProvider)menu, style.getImage("progressBar"), ProgressBar.Direction.VERTICAL);
        this.pb.active = false;
        this.widgets.add("progressBar", (AbstractWidget)this.pb);
        this.paletteButton = new PaletteButton(btn -> ((QuantumArmorConfigMenu)this.getMenu()).openStyleScreen());
        this.widgets.add("styleButton", (AbstractWidget)this.paletteButton);
    }

    protected void init() {
        super.init();
        ((QuantumArmorConfigMenu)this.menu).updateClient();
    }

    public boolean mouseClicked(double xCoord, double yCoord, int btn) {
        Slot slot;
        assert (this.minecraft != null);
        if (btn == 0 && this.isArmorSlot(slot = this.findSlot(xCoord, yCoord))) {
            this.selectedIndex = slot.index;
            ((QuantumArmorConfigMenu)this.menu).setSelectedItemSlot(slot.getSlotIndex());
        }
        return super.mouseClicked(xCoord, yCoord, btn);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.isCloseHotkey(keyCode, scanCode)) {
            this.getPlayer().closeContainer();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private boolean isCloseHotkey(int keyCode, int scanCode) {
        Hotkeys.AddonHotkey hotkey;
        String hotkeyId = ((QuantumArmorConfigMenu)this.getMenu()).getHost().getCloseHotkey();
        if (hotkeyId != null && (hotkey = AAEHotkeys.INSTANCE.getHotkeyMapping(hotkeyId)) != null) {
            return hotkey.mapping().matches(keyCode, scanCode);
        }
        return false;
    }

    private boolean isArmorSlot(Slot slot) {
        return slot != null && slot.isActive() && slot.hasItem() && ((QuantumArmorConfigMenu)this.menu).isArmorSlot(slot) && slot.getItem().getItem() instanceof QuantumArmorBase;
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        int currentRow;
        super.drawFG(guiGraphics, offsetX, offsetY, mouseX, mouseY);
        Color color = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR);
        int scrollLevel = this.scrollbar.getCurrentScroll();
        this.upgradeList.forEach(QuantumUpgradeWidget::hide);
        int visibleRows = Math.min(4, this.upgradeList.size());
        for (int i = 0; i < visibleRows && (currentRow = scrollLevel + i) < this.upgradeList.size(); ++i) {
            QuantumUpgradeWidget upgrade = this.upgradeList.get(currentRow);
            int y = 32 + i * 16;
            upgrade.setY(y, this.topPos);
            upgrade.show();
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.translate(10.0f, 8.0f + (float)i * 3.5f, 0.0f);
            poseStack.scale(0.8f, 0.8f, 1.0f);
            guiGraphics.drawString(this.font, upgrade.getType().getTranslatedName(), upgrade.getX() + 2, upgrade.getY() + 3, color.toARGB(), false);
            poseStack.popPose();
        }
    }

    public void drawBG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        super.drawBG(guiGraphics, offsetX, offsetY, mouseX, mouseY, partialTicks);
        int currentX = offsetX + 9;
        int currentY = offsetY + 32 - 1;
        int visibleRows = Math.min(4, this.upgradeList.size());
        for (int i = 0; i < visibleRows; ++i) {
            guiGraphics.blit(DEFAULT_TEXTURE, currentX, currentY, LIST_BACK_BBOX.getX(), LIST_BACK_BBOX.getY(), LIST_BACK_BBOX.getWidth(), LIST_BACK_BBOX.getHeight());
            currentY += 16;
        }
        if (this.selectedIndex != -1 && this.selectedIndex < ((QuantumArmorConfigMenu)this.menu).slots.size()) {
            Slot slot = ((QuantumArmorConfigMenu)this.menu).getSlot(this.selectedIndex);
            AEBaseScreen.renderSlotHighlight((GuiGraphics)guiGraphics, (int)(slot.x + offsetX), (int)(slot.y + offsetY), (int)0, (int)2021479361);
        }
    }

    public void refreshList(int selectedIndex, List<UpgradeState> states) {
        this.selectedIndex = selectedIndex;
        this.refreshList(states);
    }

    public void refreshList(List<UpgradeState> states) {
        this.upgradeList.forEach(w -> w.remove(x$0 -> this.removeWidget((GuiEventListener)x$0)));
        this.upgradeList.clear();
        int index = 0;
        for (UpgradeState state : states) {
            QuantumUpgradeWidget widget = new QuantumUpgradeWidget(this, index, 9, 32 + index * 16, this.style, state);
            widget.add();
            this.upgradeList.add(widget);
            ++index;
        }
        this.resetScrollbar();
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        int progress = ((QuantumArmorConfigMenu)this.menu).getCurrentProgress() * 100 / ((QuantumArmorConfigMenu)this.menu).getMaxProgress();
        if (progress >= 0) {
            this.pb.setFullMsg((Component)Component.literal((String)(progress + "%")));
        } else {
            this.pb.setFullMsg((Component)Component.literal((String)""));
        }
    }

    public void addChildWidget(String id, AbstractWidget widget, Map<String, AbstractWidget> child) {
        if (widget.isFocused()) {
            widget.setFocused(false);
        }
        widget.setX(widget.getX() + this.leftPos);
        widget.setY(widget.getY() + this.topPos);
        child.put(id, widget);
        this.addRenderableWidget((GuiEventListener)widget);
    }

    public void requestUninstall(UpgradeType upgradeType) {
        ((QuantumArmorConfigMenu)this.menu).requestUninstall(upgradeType);
    }

    private void resetScrollbar() {
        this.scrollbar.setHeight(60);
        this.scrollbar.setRange(0, this.upgradeList.size() - 4, 1);
    }

    public void onClose() {
        ((QuantumArmorConfigMenu)this.menu).emptyUpgradeSlot();
        super.onClose();
    }

    public void openConfigDialog(UpgradeState state) {
        ItemStack stack;
        if (state.type().getSettingType() == UpgradeType.SettingType.NUM_INPUT) {
            PacketDistributor.sendToServer((CustomPacketPayload)new QuantumArmorUpgradeValuePacket(state.type(), state.currentValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else if (state.type().getSettingType() == UpgradeType.SettingType.FILTER) {
            PacketDistributor.sendToServer((CustomPacketPayload)new QuantumArmorUpgradeFilterPacket(state.type(), state.filter()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else if (state.type().getSettingType() == UpgradeType.SettingType.NUM_AND_FILTER && state.type() == UpgradeType.MAGNET && (stack = ((QuantumArmorConfigMenu)this.menu).getSlot(this.selectedIndex).getItem()).getItem() instanceof QuantumArmorBase) {
            Boolean blacklist = (Boolean)stack.get(AAEComponents.UPGRADE_EXTRA.get((Object)UpgradeType.MAGNET));
            PacketDistributor.sendToServer((CustomPacketPayload)new QuantumArmorMagnetPacket(state.currentValue(), state.filter(), blacklist), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    static class PaletteButton
    extends AddonIconButton {
        public PaletteButton(Button.OnPress onPress) {
            super(onPress);
        }

        protected AAEIcon getIcon() {
            return this.isHoveredOrFocused() ? AAEIcon.PALETTE : AAEIcon.PALETTE_DISABLED;
        }
    }
}

