/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.renderer;

import appeng.block.crafting.ICraftingUnitType;
import appeng.client.render.crafting.AbstractCraftingUnitModelProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.client.renderer.QuantumComputerInternalBakedModel;
import net.pedroksl.advanced_ae.client.renderer.QuantumComputerStructureBakedModel;
import net.pedroksl.advanced_ae.common.blocks.AAECraftingUnitType;

@OnlyIn(value=Dist.CLIENT)
public class AAECraftingUnitModelProvider
extends AbstractCraftingUnitModelProvider<AAECraftingUnitType> {
    private static final List<Material> MATERIALS = new ArrayList<Material>();
    protected static final Material STRUCTURE_FORMED_FACE = AAECraftingUnitModelProvider.texture("quantum_structure_formed_face");
    protected static final Material STRUCTURE_FORMED_SIDES = AAECraftingUnitModelProvider.texture("quantum_structure_formed_sides");
    protected static final Material STRUCTURE_ANIMATION_SIDES = AAECraftingUnitModelProvider.texture("quantum_structure_powered_sides");
    protected static final Material INTERNAL_FORMED_FACE = AAECraftingUnitModelProvider.texture("quantum_internal_formed_face");
    protected static final Material INTERNAL_FORMED_SIDES = AAECraftingUnitModelProvider.texture("quantum_internal_formed_sides");
    protected static final Material INTERNAL_ANIMATION_SIDES = AAECraftingUnitModelProvider.texture("quantum_internal_powered_sides");
    protected static final Material INTERNAL_ANIMATION_FACE = AAECraftingUnitModelProvider.texture("quantum_internal_powered_animation");
    protected static final Material INTERNAL_ANIMATION_FACE_TB = AAECraftingUnitModelProvider.texture("quantum_internal_powered_animation_tb");

    public AAECraftingUnitModelProvider(AAECraftingUnitType type) {
        super((ICraftingUnitType)type);
    }

    public List<Material> getMaterials() {
        return Collections.unmodifiableList(MATERIALS);
    }

    public BakedModel getBakedModel(Function<Material, TextureAtlasSprite> spriteGetter) {
        if (this.type == AAECraftingUnitType.STRUCTURE) {
            return new QuantumComputerStructureBakedModel(spriteGetter.apply(STRUCTURE_FORMED_FACE), spriteGetter.apply(STRUCTURE_FORMED_SIDES), spriteGetter.apply(STRUCTURE_ANIMATION_SIDES));
        }
        return new QuantumComputerInternalBakedModel(spriteGetter.apply(INTERNAL_FORMED_FACE), spriteGetter.apply(INTERNAL_FORMED_SIDES), spriteGetter.apply(INTERNAL_ANIMATION_SIDES), spriteGetter.apply(INTERNAL_ANIMATION_FACE), spriteGetter.apply(INTERNAL_ANIMATION_FACE_TB), spriteGetter.apply(INTERNAL_ANIMATION_FACE_TB));
    }

    private static Material texture(String name) {
        Material material = new Material(InventoryMenu.BLOCK_ATLAS, AdvancedAE.makeId("block/crafting/" + name));
        MATERIALS.add(material);
        return material;
    }
}

