/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.helpers;

import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.util.prioritylist.IPartitionList;

public class FilteredImportStackTransferContext
implements StackTransferContext {
    private final IStorageService internalStorage;
    private final IEnergySource energySource;
    private final IActionSource actionSource;
    private final IPartitionList filter;
    private final int initialOperations;
    private int operationsRemaining;
    private boolean isInverted;

    public FilteredImportStackTransferContext(IStorageService internalStorage, IEnergySource energySource, IActionSource actionSource, int operationsRemaining, IPartitionList filter) {
        this.internalStorage = internalStorage;
        this.energySource = energySource;
        this.actionSource = actionSource;
        this.filter = filter;
        this.initialOperations = operationsRemaining;
        this.operationsRemaining = operationsRemaining;
    }

    public IStorageService getInternalStorage() {
        return this.internalStorage;
    }

    public IEnergySource getEnergySource() {
        return this.energySource;
    }

    public IActionSource getActionSource() {
        return this.actionSource;
    }

    public int getOperationsRemaining() {
        return this.operationsRemaining;
    }

    public void setOperationsRemaining(int operationsRemaining) {
        this.operationsRemaining = operationsRemaining;
    }

    public boolean hasOperationsLeft() {
        return this.operationsRemaining > 0;
    }

    public boolean hasDoneWork() {
        return this.initialOperations > this.operationsRemaining;
    }

    public boolean isKeyTypeEnabled(AEKeyType space) {
        return true;
    }

    public boolean isInFilter(AEKey key) {
        return this.filter.isEmpty() || this.filter.isListed(key);
    }

    public IPartitionList getFilter() {
        return this.filter;
    }

    public void setInverted(boolean inverted) {
        this.isInverted = !inverted;
    }

    public boolean isInverted() {
        return !this.filter.isEmpty() && this.isInverted;
    }

    public boolean canInsert(AEItemKey what, long amount) {
        return this.internalStorage.getInventory().insert((AEKey)what, amount, Actionable.SIMULATE, this.actionSource) > 0L;
    }

    public void reduceOperationsRemaining(long inserted) {
        this.operationsRemaining = (int)((long)this.operationsRemaining - inserted);
    }
}

