/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.items.upgrades;

import appeng.core.localization.Tooltips;
import appeng.items.AEBaseItem;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;

public class QuantumUpgradeBaseItem
extends AEBaseItem {
    private final UpgradeType type;

    public QuantumUpgradeBaseItem(Item.Properties properties) {
        super(properties);
        this.type = UpgradeType.EMPTY;
    }

    public QuantumUpgradeBaseItem(UpgradeType type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    public UpgradeType getType() {
        return this.type;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, lines, tooltipFlag);
        if (this.type == UpgradeType.EMPTY) {
            lines.add((Component)this.type.getTooltip());
            return;
        }
        lines.add((Component)AAEText.QuantumUpgradeTooltip.text().withStyle(Tooltips.NUMBER_TEXT));
        lines.add((Component)this.type.getTooltip());
        List<QuantumArmorBase> list = QuantumArmorBase.upgradeAvailableFor(this.type);
        lines.add((Component)Component.empty());
        lines.add((Component)AAEText.UpgradeTooltip.text().withStyle(Tooltips.NORMAL_TOOLTIP_TEXT));
        for (QuantumArmorBase equip : list) {
            lines.add((Component)Component.translatable((String)equip.getDescriptionId()).withStyle(Tooltips.NORMAL_TOOLTIP_TEXT));
        }
    }
}

