/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.gui;

import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.stacks.AEKey;
import appeng.api.storage.ILinkStatus;
import appeng.core.AELog;
import appeng.core.network.ClientboundPacket;
import appeng.core.network.clientbound.SetLinkStatusPacket;
import appeng.helpers.InventoryAction;
import appeng.menu.AEBaseMenu;
import appeng.menu.guisync.GuiSync;
import appeng.menu.guisync.LinkStatusAwareMenu;
import appeng.menu.locator.MenuHostLocator;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2BooleanArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.pedroksl.advanced_ae.api.AAESettings;
import net.pedroksl.advanced_ae.api.IQuantumCrafterTermMenuHost;
import net.pedroksl.advanced_ae.api.ShowQuantumCrafters;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.helpers.AutoCraftingContainer;
import net.pedroksl.advanced_ae.gui.QuantumCrafterConfigPatternMenu;
import net.pedroksl.advanced_ae.network.packet.ClearQuantumCrafterTerminalPacket;
import net.pedroksl.advanced_ae.network.packet.QuantumCrafterTerminalClientAction;
import net.pedroksl.advanced_ae.network.packet.QuantumCrafterTerminalPacket;
import org.jetbrains.annotations.Nullable;

public class QuantumCrafterTermMenu
extends AEBaseMenu
implements LinkStatusAwareMenu {
    private final IQuantumCrafterTermMenuHost host;
    @GuiSync(value=1)
    public ShowQuantumCrafters showQuantumCrafters = ShowQuantumCrafters.VISIBLE;
    private ILinkStatus linkStatus = ILinkStatus.ofDisconnected();
    private static long inventorySerial = Long.MIN_VALUE;
    private final Map<AutoCraftingContainer, ContainerTracker> diList = new IdentityHashMap<AutoCraftingContainer, ContainerTracker>();
    private final Long2ObjectOpenHashMap<ContainerTracker> byId = new Long2ObjectOpenHashMap();
    private final Set<AutoCraftingContainer> pinnedHosts = Collections.newSetFromMap(new IdentityHashMap());

    public QuantumCrafterTermMenu(int id, Inventory playerInventory, IQuantumCrafterTermMenuHost host) {
        this(AAEMenus.QUANTUM_CRAFTER_TERMINAL.get(), id, playerInventory, host, true);
    }

    public QuantumCrafterTermMenu(MenuType<?> menuType, int id, Inventory playerInventory, IQuantumCrafterTermMenuHost host, boolean bindInventory) {
        super(menuType, id, playerInventory, (Object)host);
        this.host = host;
        if (bindInventory) {
            this.createPlayerInventorySlots(playerInventory);
        }
    }

    public ShowQuantumCrafters getShownQuantumCrafters() {
        return this.showQuantumCrafters;
    }

    public void broadcastChanges() {
        if (this.isClientSide()) {
            return;
        }
        this.showQuantumCrafters = (ShowQuantumCrafters)this.host.getConfigManager().getSetting(AAESettings.TERMINAL_SHOW_QUANTUM_CRAFTERS);
        super.broadcastChanges();
        this.updateLinkStatus();
        if (this.showQuantumCrafters != ShowQuantumCrafters.NOT_FULL) {
            this.pinnedHosts.clear();
        }
        IGrid grid = this.getGrid();
        VisitorState state = new VisitorState();
        if (grid != null) {
            for (Class machineClass : grid.getMachineClasses()) {
                if (!AutoCraftingContainer.class.isAssignableFrom(machineClass)) continue;
                this.visitPatternProviderHosts(grid, machineClass, state);
            }
            this.pinnedHosts.removeIf(host -> host.getGrid() != grid);
        } else {
            this.pinnedHosts.clear();
        }
        if (state.total != this.diList.size() || state.forceFullUpdate) {
            this.sendFullUpdate(grid);
        } else {
            this.sendIncrementalUpdate();
        }
    }

    @Nullable
    private IGrid getGrid() {
        IGridNode agn;
        IActionHost aHost = this.getActionHost();
        if (aHost != null && (agn = aHost.getActionableNode()) != null && agn.isActive()) {
            return agn.getGrid();
        }
        return null;
    }

    private boolean isFull(AutoCraftingContainer logic) {
        for (int i = 0; i < logic.getTerminalPatternInventory().size(); ++i) {
            if (!logic.getTerminalPatternInventory().getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private boolean isVisible(AutoCraftingContainer container) {
        boolean isVisible = container.isVisibleInTerminal();
        return switch (this.getShownQuantumCrafters()) {
            default -> throw new MatchException(null, null);
            case ShowQuantumCrafters.VISIBLE -> isVisible;
            case ShowQuantumCrafters.NOT_FULL -> {
                if (isVisible && (this.pinnedHosts.contains(container) || !this.isFull(container))) {
                    yield true;
                }
                yield false;
            }
            case ShowQuantumCrafters.ALL -> true;
        };
    }

    private <T extends AutoCraftingContainer> void visitPatternProviderHosts(IGrid grid, Class<T> machineClass, VisitorState state) {
        for (AutoCraftingContainer container : grid.getActiveMachines(machineClass)) {
            ContainerTracker t;
            if (!this.isVisible(container)) continue;
            if (this.getShownQuantumCrafters() == ShowQuantumCrafters.NOT_FULL) {
                this.pinnedHosts.add(container);
            }
            if ((t = this.diList.get(container)) == null) {
                state.forceFullUpdate = true;
            }
            ++state.total;
        }
    }

    public void configPattern(long serverId, int slot) {
        if (this.isClientSide()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new QuantumCrafterTerminalClientAction(true, serverId, slot), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        ContainerTracker inv = (ContainerTracker)this.byId.get(serverId);
        if (inv == null) {
            return;
        }
        if (slot < 0 || slot >= inv.server.size()) {
            AELog.warn((String)"Client refers to invalid slot %d of inventory %s", (Object[])new Object[]{slot, inv.container});
            return;
        }
        MenuHostLocator locator = this.getLocator();
        if (locator != null) {
            LinkedHashMap<AEKey, Long> inputs = inv.container.getPatternConfigInputs(slot);
            Pair<AEKey, Long> output = inv.container.getPatternConfigOutput(slot);
            if (inputs == null || output == null) {
                return;
            }
            QuantumCrafterConfigPatternMenu.open((ServerPlayer)this.getPlayer(), locator, inv.container, slot, inputs, output);
        }
    }

    public void toggleEnabledPattern(long serverId, int slot) {
        if (this.isClientSide()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new QuantumCrafterTerminalClientAction(false, serverId, slot), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        ContainerTracker inv = (ContainerTracker)this.byId.get(serverId);
        if (inv == null) {
            return;
        }
        if (slot < 0 || slot >= inv.server.size()) {
            AELog.warn((String)"Client refers to invalid slot %d of inventory %s", (Object[])new Object[]{slot, inv.container});
            return;
        }
        inv.container.toggleEnablePattern(slot);
    }

    public void doAction(ServerPlayer player, InventoryAction action, int slot, long id) {
        ContainerTracker inv = (ContainerTracker)this.byId.get(id);
        if (inv == null) {
            return;
        }
        if (slot < 0 || slot >= inv.server.size()) {
            AELog.warn((String)"Client refers to invalid slot %d of inventory %s", (Object[])new Object[]{slot, inv.container});
            return;
        }
        ItemStack is = inv.server.getStackInSlot(slot);
        FilteredInternalInventory patternSlot = new FilteredInternalInventory(inv.server.getSlotInv(slot), (IAEItemFilter)new PatternSlotFilter());
        ItemStack carried = this.getCarried();
        switch (action) {
            case PICKUP_OR_SET_DOWN: {
                if (!carried.isEmpty()) {
                    ItemStack inSlot = patternSlot.getStackInSlot(0);
                    if (inSlot.isEmpty()) {
                        this.setCarried(patternSlot.addItems(carried));
                        break;
                    }
                    inSlot = inSlot.copy();
                    ItemStack inHand = carried.copy();
                    patternSlot.setItemDirect(0, ItemStack.EMPTY);
                    this.setCarried(ItemStack.EMPTY);
                    this.setCarried(patternSlot.addItems(inHand.copy()));
                    if (this.getCarried().isEmpty()) {
                        this.setCarried(inSlot);
                        break;
                    }
                    this.setCarried(inHand);
                    patternSlot.setItemDirect(0, inSlot);
                    break;
                }
                this.setCarried(patternSlot.getStackInSlot(0));
                patternSlot.setItemDirect(0, ItemStack.EMPTY);
                break;
            }
            case SPLIT_OR_PLACE_SINGLE: {
                if (!carried.isEmpty()) {
                    ItemStack extra = carried.split(1);
                    if (!extra.isEmpty()) {
                        extra = patternSlot.addItems(extra);
                    }
                    if (extra.isEmpty()) break;
                    carried.grow(extra.getCount());
                    break;
                }
                if (is.isEmpty()) break;
                this.setCarried(patternSlot.extractItem(0, (is.getCount() + 1) / 2, false));
                break;
            }
            case SHIFT_CLICK: {
                ItemStack stack = patternSlot.getStackInSlot(0).copy();
                if (!player.getInventory().add(stack)) {
                    patternSlot.setItemDirect(0, stack);
                    break;
                }
                patternSlot.setItemDirect(0, ItemStack.EMPTY);
                break;
            }
            case MOVE_REGION: {
                for (int x = 0; x < inv.server.size(); ++x) {
                    ItemStack stack = inv.server.getStackInSlot(x);
                    if (!player.getInventory().add(stack)) {
                        patternSlot.setItemDirect(0, stack);
                        continue;
                    }
                    patternSlot.setItemDirect(0, ItemStack.EMPTY);
                }
                break;
            }
            case CREATIVE_DUPLICATE: {
                if (!player.getAbilities().instabuild || !carried.isEmpty()) break;
                this.setCarried(is.isEmpty() ? ItemStack.EMPTY : is.copy());
            }
        }
    }

    private void sendFullUpdate(@Nullable IGrid grid) {
        this.byId.clear();
        this.diList.clear();
        this.sendPacketToClient(new ClearQuantumCrafterTerminalPacket());
        if (grid == null) {
            return;
        }
        for (Class machineClass : grid.getMachineClasses()) {
            Class<? extends AutoCraftingContainer> containerClass = QuantumCrafterTermMenu.tryCastMachineToContainer(machineClass);
            if (containerClass == null) continue;
            for (AutoCraftingContainer container : grid.getActiveMachines(containerClass)) {
                if (!this.isVisible(container)) continue;
                this.diList.put(container, new ContainerTracker(container, container.getTerminalPatternInventory(), container.getEnabledPatternSlots(), container.getInvalidPatternSlots()));
            }
        }
        for (ContainerTracker inv : this.diList.values()) {
            this.byId.put(inv.serverId, (Object)inv);
            this.sendPacketToClient(inv.createFullPacket());
        }
    }

    private void sendIncrementalUpdate() {
        for (ContainerTracker inv : this.diList.values()) {
            QuantumCrafterTerminalPacket packet = inv.createUpdatePacket();
            if (packet == null) continue;
            this.sendPacketToClient(packet);
        }
    }

    private static Class<? extends AutoCraftingContainer> tryCastMachineToContainer(Class<?> machineClass) {
        if (AutoCraftingContainer.class.isAssignableFrom(machineClass)) {
            return machineClass.asSubclass(AutoCraftingContainer.class);
        }
        return null;
    }

    protected void updateLinkStatus() {
        ILinkStatus linkStatus = this.host.getLinkStatus();
        if (!Objects.equals(this.linkStatus, linkStatus)) {
            this.linkStatus = linkStatus;
            this.sendPacketToClient((ClientboundPacket)new SetLinkStatusPacket(linkStatus));
        }
    }

    public ILinkStatus getLinkStatus() {
        return this.linkStatus;
    }

    public void setLinkStatus(ILinkStatus linkStatus) {
        this.linkStatus = linkStatus;
    }

    private static class VisitorState {
        int total;
        boolean forceFullUpdate;

        private VisitorState() {
        }
    }

    private static class ContainerTracker {
        private final AutoCraftingContainer container;
        private final long sortBy;
        private final long serverId = inventorySerial++;
        private final InternalInventory client;
        private final List<Boolean> clientEnabled;
        private final List<Boolean> clientInvalid;
        private final InternalInventory server;
        private final List<Boolean> serverEnabled;
        private final List<Boolean> serverInvalid;

        public ContainerTracker(AutoCraftingContainer container, InternalInventory patterns, List<Boolean> enabledList, List<Boolean> invalidList) {
            this.container = container;
            this.server = patterns;
            this.client = new AppEngInternalInventory(this.server.size());
            this.serverEnabled = enabledList;
            this.clientEnabled = new ArrayList<Boolean>(enabledList);
            this.serverInvalid = invalidList;
            this.clientInvalid = new ArrayList<Boolean>(invalidList);
            this.sortBy = container.getTerminalSortOrder();
        }

        public QuantumCrafterTerminalPacket createFullPacket() {
            Int2ObjectArrayMap slots = new Int2ObjectArrayMap(this.server.size());
            Int2BooleanArrayMap enabledArray = new Int2BooleanArrayMap(this.server.size());
            Int2BooleanArrayMap invalidArray = new Int2BooleanArrayMap(this.server.size());
            for (int i = 0; i < this.server.size(); ++i) {
                ItemStack stack = this.server.getStackInSlot(i);
                if (!stack.isEmpty()) {
                    slots.put(i, (Object)stack);
                }
                enabledArray.put(i, this.serverEnabled.get(i).booleanValue());
                invalidArray.put(i, this.serverInvalid.get(i).booleanValue());
            }
            return QuantumCrafterTerminalPacket.fullUpdate(this.serverId, this.server.size(), this.sortBy, (Int2ObjectMap<ItemStack>)slots, enabledArray, invalidArray);
        }

        @Nullable
        public QuantumCrafterTerminalPacket createUpdatePacket() {
            IntList changedSlots = this.detectChangedSlots();
            if (changedSlots == null) {
                return null;
            }
            Int2ObjectArrayMap slots = new Int2ObjectArrayMap(changedSlots.size());
            Int2BooleanArrayMap enabledArray = new Int2BooleanArrayMap(changedSlots.size());
            Int2BooleanArrayMap invalidArray = new Int2BooleanArrayMap(changedSlots.size());
            for (int i = 0; i < changedSlots.size(); ++i) {
                int slot;
                ItemStack stack = this.server.getStackInSlot(slot = changedSlots.getInt(i));
                this.client.setItemDirect(slot, stack.isEmpty() ? ItemStack.EMPTY : stack.copy());
                slots.put(slot, (Object)stack);
                Boolean enabled = this.serverEnabled.get(slot);
                this.clientEnabled.set(slot, enabled);
                enabledArray.put(slot, enabled.booleanValue());
                Boolean invalid = this.serverInvalid.get(slot);
                this.clientInvalid.set(slot, invalid);
                invalidArray.put(slot, invalid.booleanValue());
            }
            return QuantumCrafterTerminalPacket.incrementalUpdate(this.serverId, (Int2ObjectMap<ItemStack>)slots, enabledArray, invalidArray);
        }

        @Nullable
        private IntList detectChangedSlots() {
            IntArrayList changedSlots = null;
            for (int x = 0; x < this.server.size(); ++x) {
                if (!ContainerTracker.isDifferent(this.server.getStackInSlot(x), this.client.getStackInSlot(x)) && this.serverEnabled.get(x) == this.clientEnabled.get(x) && this.serverInvalid.get(x) == this.clientInvalid.get(x)) continue;
                if (changedSlots == null) {
                    changedSlots = new IntArrayList();
                }
                changedSlots.add(x);
            }
            return changedSlots;
        }

        private static boolean isDifferent(ItemStack a, ItemStack b) {
            if (a.isEmpty() && b.isEmpty()) {
                return false;
            }
            if (a.isEmpty() || b.isEmpty()) {
                return true;
            }
            return !ItemStack.matches((ItemStack)a, (ItemStack)b);
        }
    }

    private static class PatternSlotFilter
    implements IAEItemFilter {
        private PatternSlotFilter() {
        }

        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return true;
        }

        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            return !stack.isEmpty() && PatternDetailsHelper.isEncodedPattern((ItemStack)stack);
        }
    }
}

