/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl;

import com.refinedmods.refinedstorage.api.core.component.ComponentMap;
import com.refinedmods.refinedstorage.api.core.component.ComponentMapFactory;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.NetworkComponent;
import com.refinedmods.refinedstorage.api.network.node.container.NetworkNodeContainer;
import java.util.Set;

public class NetworkImpl
implements Network {
    private final ComponentMap<NetworkComponent> componentMap;

    public NetworkImpl(ComponentMapFactory<NetworkComponent, Network> componentMapFactory) {
        this.componentMap = componentMapFactory.buildComponentMap(this);
    }

    @Override
    public void addContainer(NetworkNodeContainer container) {
        this.componentMap.getComponents().forEach(c -> c.onContainerAdded(container));
    }

    @Override
    public void removeContainer(NetworkNodeContainer container) {
        this.componentMap.getComponents().forEach(c -> c.onContainerRemoved(container));
    }

    @Override
    public void remove() {
        this.componentMap.getComponents().forEach(NetworkComponent::onNetworkRemoved);
    }

    @Override
    public void split(Set<Network> networks) {
        this.componentMap.getComponents().forEach(c -> c.onNetworkSplit(networks));
    }

    @Override
    public void merge(Network network) {
        this.componentMap.getComponents().forEach(c -> c.onNetworkMergedWith(network));
    }

    @Override
    public <I extends NetworkComponent> I getComponent(Class<I> componentType) {
        return (I)((NetworkComponent)this.componentMap.getComponent(componentType));
    }
}

