/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.resource.list.listenable;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.AbstractProxyMutableResourceList;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.resource.list.listenable.ResourceListListener;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0-milestone.1.2")
public class ListenableResourceList
extends AbstractProxyMutableResourceList {
    private final Set<ResourceListListener> listeners = new HashSet<ResourceListListener>();

    public ListenableResourceList(MutableResourceList delegate) {
        super(delegate);
    }

    @Override
    public MutableResourceList.OperationResult add(ResourceKey resource, long amount) {
        MutableResourceList.OperationResult result = super.add(resource, amount);
        this.notifyListeners(result);
        return result;
    }

    @Override
    @Nullable
    public MutableResourceList.OperationResult remove(ResourceKey resource, long amount) {
        MutableResourceList.OperationResult result = super.remove(resource, amount);
        if (result != null) {
            this.notifyListeners(result);
        }
        return result;
    }

    private void notifyListeners(MutableResourceList.OperationResult result) {
        this.listeners.forEach(listener -> listener.changed(result));
    }

    public void addListener(ResourceListListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ResourceListListener listener) {
        this.listeners.remove(listener);
    }
}

