/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.resource.repository;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceListImpl;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepository;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepositoryBuilder;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepositoryImpl;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepositoryMapper;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0-milestone.2.4")
public class ResourceRepositoryBuilderImpl<T>
implements ResourceRepositoryBuilder<T> {
    private final ResourceRepositoryMapper<T> mapper;
    private final MutableResourceList backingList = MutableResourceListImpl.create();
    private final Set<ResourceKey> stickyResources = new HashSet<ResourceKey>();
    private final Function<ResourceRepository<T>, Comparator<T>> identitySortingType;
    private final Function<ResourceRepository<T>, Comparator<T>> defaultSortingType;

    public ResourceRepositoryBuilderImpl(ResourceRepositoryMapper<T> mapper, Function<ResourceRepository<T>, Comparator<T>> identitySortingType, Function<ResourceRepository<T>, Comparator<T>> defaultSortingType) {
        this.mapper = mapper;
        this.identitySortingType = identitySortingType;
        this.defaultSortingType = defaultSortingType;
    }

    @Override
    public ResourceRepositoryBuilder<T> addResource(ResourceKey resource, long amount) {
        this.backingList.add(resource, amount);
        return this;
    }

    @Override
    public ResourceRepositoryBuilder<T> addStickyResource(ResourceKey resource) {
        this.stickyResources.add(resource);
        return this;
    }

    @Override
    public ResourceRepository<T> build() {
        return new ResourceRepositoryImpl<T>(this.mapper, this.backingList, this.stickyResources, this.identitySortingType, this.defaultSortingType);
    }
}

