/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.networking;

import com.google.common.util.concurrent.RateLimiter;
import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.networking.NetworkCardInventory;
import com.refinedmods.refinedstorage.common.networking.NetworkCardItem;
import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterBlockEntity;
import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterData;
import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.ValidatedSlot;
import com.refinedmods.refinedstorage.common.support.packet.s2c.S2CPackets;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class NetworkTransmitterContainerMenu
extends AbstractBaseContainerMenu {
    @Nullable
    private final NetworkTransmitterBlockEntity blockEntity;
    private final Player player;
    private final RateLimiter statusUpdateRateLimiter = RateLimiter.create((double)2.0);
    private NetworkTransmitterData status;

    NetworkTransmitterContainerMenu(int syncId, Inventory playerInventory, NetworkTransmitterBlockEntity blockEntity) {
        super(Menus.INSTANCE.getNetworkTransmitter(), syncId);
        this.registerProperty(new ServerProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, blockEntity::getRedstoneMode, blockEntity::setRedstoneMode));
        this.blockEntity = blockEntity;
        this.player = playerInventory.player;
        this.status = blockEntity.getStatus();
        this.addSlots(playerInventory, blockEntity.getNetworkCardInventory());
    }

    public NetworkTransmitterContainerMenu(int syncId, Inventory playerInventory, NetworkTransmitterData status) {
        super(Menus.INSTANCE.getNetworkTransmitter(), syncId);
        this.registerProperty(new ClientProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, RedstoneMode.IGNORE));
        this.blockEntity = null;
        this.player = playerInventory.player;
        this.status = status;
        this.addSlots(playerInventory, (Container)new NetworkCardInventory());
    }

    public void broadcastChanges() {
        Player player;
        super.broadcastChanges();
        if (this.blockEntity == null || !((player = this.player) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (!this.statusUpdateRateLimiter.tryAcquire()) {
            return;
        }
        NetworkTransmitterData newStatus = this.blockEntity.getStatus();
        if (newStatus.equals(this.status)) {
            return;
        }
        this.updateStatus(serverPlayer, newStatus);
    }

    public boolean stillValid(Player p) {
        if (this.blockEntity == null) {
            return true;
        }
        return Container.stillValidBlockEntity((BlockEntity)this.blockEntity, (Player)p);
    }

    private void updateStatus(ServerPlayer serverPlayer, NetworkTransmitterData newStatus) {
        this.status = newStatus;
        S2CPackets.sendNetworkTransmitterStatus(serverPlayer, newStatus);
    }

    private void addSlots(Inventory playerInventory, Container networkCardInventory) {
        this.addPlayerInventory(playerInventory, 8, 55);
        this.addSlot(new ValidatedSlot(networkCardInventory, 0, 8, 20, stack -> {
            NetworkCardItem networkCardItem;
            Item patt0$temp = stack.getItem();
            return patt0$temp instanceof NetworkCardItem && (networkCardItem = (NetworkCardItem)patt0$temp).isActive((ItemStack)stack);
        }));
        this.transferManager.addBiTransfer((Container)playerInventory, networkCardInventory);
    }

    NetworkTransmitterData getStatus() {
        return this.status;
    }

    public void setStatus(NetworkTransmitterData status) {
        this.status = status;
    }
}

