/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.security;

import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.security.AbstractSecurityCardContainerMenu;
import com.refinedmods.refinedstorage.common.security.PlayerBoundSecurityCardData;
import com.refinedmods.refinedstorage.common.security.SecurityCardItem;
import com.refinedmods.refinedstorage.common.support.packet.c2s.C2SPackets;
import com.refinedmods.refinedstorage.common.support.stretching.ScreenSizeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SecurityCardContainerMenu
extends AbstractSecurityCardContainerMenu
implements ScreenSizeListener {
    private final List<PlayerBoundSecurityCardData.Player> players;
    private PlayerBoundSecurityCardData.Player boundTo;

    public SecurityCardContainerMenu(int syncId, Inventory playerInventory, PlayerBoundSecurityCardData playerBoundSecurityCardData) {
        super(Menus.INSTANCE.getSecurityCard(), syncId, playerInventory, playerBoundSecurityCardData.securityCardData());
        this.boundTo = playerBoundSecurityCardData.boundTo();
        this.players = playerBoundSecurityCardData.players();
    }

    SecurityCardContainerMenu(int syncId, Inventory playerInventory, SlotReference disabledSlot) {
        super(Menus.INSTANCE.getSecurityCard(), syncId, playerInventory, disabledSlot);
        this.boundTo = new PlayerBoundSecurityCardData.Player(UUID.randomUUID(), "");
        this.players = new ArrayList<PlayerBoundSecurityCardData.Player>();
    }

    List<PlayerBoundSecurityCardData.Player> getPlayers() {
        return this.players;
    }

    PlayerBoundSecurityCardData.Player getBoundTo() {
        return this.boundTo;
    }

    public void setBoundPlayer(MinecraftServer server, UUID playerId) {
        if (this.disabledSlot == null) {
            return;
        }
        this.disabledSlot.resolve(this.playerInventory.player).ifPresent(stack -> this.setBoundPlayer(server, playerId, (ItemStack)stack));
    }

    private void setBoundPlayer(MinecraftServer server, UUID playerId, ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof SecurityCardItem) {
            SecurityCardItem securityCardItem = (SecurityCardItem)item;
            ServerPlayer player = server.getPlayerList().getPlayer(playerId);
            if (player == null) {
                return;
            }
            securityCardItem.setBoundPlayer(player, stack);
        }
    }

    void changeBoundPlayer(PlayerBoundSecurityCardData.Player player) {
        C2SPackets.sendSecurityCardBoundPlayer(player.id());
        this.boundTo = player;
    }

    public boolean stillValid(Player player) {
        return true;
    }
}

