/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.refinedmods.refinedstorage.common.storage.AbstractStorageContainerMenu;
import com.refinedmods.refinedstorage.common.storage.AbstractStorageScreen;
import com.refinedmods.refinedstorage.common.storage.StorageAccessor;
import com.refinedmods.refinedstorage.common.storage.StorageTooltipHelper;
import com.refinedmods.refinedstorage.common.support.widget.ProgressWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public abstract class AbstractProgressStorageScreen<T extends AbstractStorageContainerMenu>
extends AbstractStorageScreen<T> {
    private final ProgressWidget progressWidget;

    protected AbstractProgressStorageScreen(T menu, Inventory inventory, Component title, int progressWidgetX) {
        super(menu, inventory, title);
        this.inventoryLabelY = 129;
        this.imageWidth = 176;
        this.imageHeight = 223;
        this.progressWidget = new ProgressWidget(progressWidgetX, 54, 16, 70, ((StorageAccessor)menu)::getProgress, this::createProgressTooltip);
        this.addRenderableWidget((GuiEventListener)this.progressWidget);
    }

    private List<Component> createProgressTooltip() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (((StorageAccessor)((Object)((AbstractStorageContainerMenu)this.menu))).hasCapacity()) {
            StorageTooltipHelper.addAmountStoredWithCapacity(tooltip, ((StorageAccessor)((Object)((AbstractStorageContainerMenu)this.menu))).getStored(), ((StorageAccessor)((Object)((AbstractStorageContainerMenu)this.menu))).getCapacity(), this::formatAmount);
        } else {
            StorageTooltipHelper.addAmountStoredWithoutCapacity(tooltip, ((StorageAccessor)((Object)((AbstractStorageContainerMenu)this.menu))).getStored(), this::formatAmount);
        }
        return tooltip;
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        this.progressWidget.render(graphics, mouseX - this.leftPos, mouseY - this.topPos, 0.0f);
    }
}

