/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.amount;

import com.refinedmods.refinedstorage.common.support.amount.AbstractAmountScreen;
import com.refinedmods.refinedstorage.common.support.amount.AmountScreenConfiguration;
import com.refinedmods.refinedstorage.common.support.amount.DoubleAmountOperations;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractResourceContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3f;

public class ResourceAmountScreen
extends AbstractAmountScreen<SingleResourceContainerMenu, Double> {
    private static final ResourceLocation TEXTURE = IdentifierUtil.createIdentifier("textures/gui/resource_amount.png");
    private static final MutableComponent TITLE = IdentifierUtil.createTranslation("gui", "configure_amount");
    private final ResourceSlot slot;

    public ResourceAmountScreen(Screen parent, Inventory playerInventory, ResourceSlot slot) {
        super(new SingleResourceContainerMenu(slot, 89, 48), parent, playerInventory, (Component)TITLE, AmountScreenConfiguration.AmountScreenConfigurationBuilder.create().withInitialAmount(slot.getDisplayAmount()).withIncrementsTop(1, 10, 64).withIncrementsBottom(-1, -10, -64).withIncrementsBottomStartPosition(new Vector3f(7.0f, 72.0f, 0.0f)).withAmountFieldPosition(new Vector3f(9.0f, 51.0f, 0.0f)).withActionButtonsStartPosition(new Vector3f(114.0f, 22.0f, 0.0f)).withMinAmount(() -> slot.getResource() != null ? slot.getResource().getResourceType().getDisplayAmount(1L) : 1.0).withMaxAmount(slot.getMaxAmountWhenModifying()).withResetAmount(1.0).build(), DoubleAmountOperations.INSTANCE);
        this.slot = slot;
        this.imageWidth = 180;
        this.imageHeight = 99;
    }

    @Override
    protected boolean confirm(Double amount) {
        this.slot.changeAmountOnClient(amount);
        return true;
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    public static class SingleResourceContainerMenu
    extends AbstractResourceContainerMenu {
        public SingleResourceContainerMenu(ResourceSlot slot, int x, int y) {
            super(null, 0);
            this.addSlot(slot.forAmountScreen(x, y));
        }

        @Override
        public ItemStack quickMoveStack(Player player, int slot) {
            return ItemStack.EMPTY;
        }

        public boolean stillValid(Player player) {
            return true;
        }
    }
}

