/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.containermenu;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.common.support.containermenu.DisabledResourceSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlotType;
import com.refinedmods.refinedstorage.common.support.packet.c2s.C2SPackets;
import com.refinedmods.refinedstorage.common.support.packet.s2c.S2CPackets;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceSlot
extends Slot {
    private static final Component CLICK_TO_CONFIGURE_AMOUNT = IdentifierUtil.createTranslationAsHeading("gui", "filter_slot.click_to_configure_amount");
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceSlot.class);
    protected final ResourceContainer resourceContainer;
    private final Component helpText;
    private final ResourceSlotType type;
    @Nullable
    private ResourceAmount cachedResource;

    public ResourceSlot(ResourceContainer resourceContainer, int index, Component helpText, int x, int y, ResourceSlotType type) {
        this(resourceContainer, (Container)new SimpleContainer(resourceContainer.size()), index, helpText, x, y, type);
    }

    public ResourceSlot(ResourceContainer resourceContainer, Container resourceContainerAsContainer, int index, Component helpText, int x, int y, ResourceSlotType type) {
        super(resourceContainerAsContainer, index, x, y);
        this.resourceContainer = resourceContainer;
        this.helpText = helpText;
        this.cachedResource = resourceContainer.get(index);
        this.type = type;
    }

    public ResourceSlot forAmountScreen(int newX, int newY) {
        return new DisabledResourceSlot(this.resourceContainer, this.container, this.getContainerSlot(), this.helpText, newX, newY, this.type);
    }

    public boolean shouldRenderAmount() {
        if (this.type == ResourceSlotType.FILTER_WITH_AMOUNT) {
            return true;
        }
        if (this.type == ResourceSlotType.CONTAINER) {
            if (this.getResource() instanceof ItemResource) {
                return this.getAmount() == 1L;
            }
            return true;
        }
        return false;
    }

    public boolean isFilter() {
        return this.type == ResourceSlotType.FILTER || this.type == ResourceSlotType.FILTER_WITH_AMOUNT;
    }

    public boolean canModifyAmount() {
        return this.type == ResourceSlotType.FILTER_WITH_AMOUNT;
    }

    public boolean supportsItemSlotInteractions() {
        return this.type == ResourceSlotType.CONTAINER;
    }

    public boolean isDisabled() {
        return false;
    }

    @Nullable
    public PlatformResourceKey getResource() {
        return this.resourceContainer.getResource(this.getContainerSlot());
    }

    public long getAmount() {
        return this.resourceContainer.getAmount(this.getContainerSlot());
    }

    private ItemStack getStackRepresentation() {
        return this.resourceContainer.getStackRepresentation(this.getContainerSlot());
    }

    public boolean isEmpty() {
        return this.resourceContainer.isEmpty(this.getContainerSlot());
    }

    public void change(ItemStack stack, boolean tryAlternatives) {
        this.resourceContainer.change(this.getContainerSlot(), stack, tryAlternatives);
    }

    public void change(@Nullable ResourceAmount resourceAmount) {
        if (resourceAmount == null) {
            this.resourceContainer.remove(this.getContainerSlot());
        } else {
            this.resourceContainer.set(this.getContainerSlot(), resourceAmount);
        }
    }

    public void setFilter(PlatformResourceKey resource) {
        if (!this.isFilter() || !this.isValid(resource)) {
            return;
        }
        this.resourceContainer.set(this.getContainerSlot(), new ResourceAmount(resource, resource.getResourceType().normalizeAmount(1.0)));
    }

    public boolean isValid(ResourceKey resource) {
        return this.resourceContainer.isValid(resource);
    }

    public boolean changeIfEmpty(ItemStack stack) {
        if (!this.isEmpty()) {
            return false;
        }
        this.resourceContainer.change(this.getContainerSlot(), stack, false);
        return true;
    }

    public void changeAmount(long amount) {
        if (this.type != ResourceSlotType.FILTER_WITH_AMOUNT) {
            return;
        }
        this.resourceContainer.setAmount(this.getContainerSlot(), amount);
    }

    public void changeAmountOnClient(double amount) {
        PlatformResourceKey resource = this.getResource();
        if (resource == null) {
            return;
        }
        long normalizedAmount = resource.getResourceType().normalizeAmount(amount);
        C2SPackets.sendResourceSlotAmountChange(this.index, normalizedAmount);
    }

    public boolean contains(ItemStack stack) {
        return ItemStack.matches((ItemStack)stack, (ItemStack)this.getStackRepresentation());
    }

    public boolean broadcastChanges(Player player) {
        ResourceAmount currentResourceAmount = this.resourceContainer.get(this.getContainerSlot());
        if (!Objects.equals(currentResourceAmount, this.cachedResource)) {
            LOGGER.debug("Resource slot {} has changed", (Object)this.getContainerSlot());
            this.cachedResource = currentResourceAmount;
            this.broadcastChange((ServerPlayer)player, currentResourceAmount);
            return true;
        }
        return false;
    }

    private void broadcastChange(ServerPlayer player, @Nullable ResourceAmount contents) {
        S2CPackets.sendResourceSlotUpdate(player, contents, this.index);
    }

    public boolean mayPickup(Player player) {
        return this.supportsItemSlotInteractions();
    }

    public boolean mayPlace(ItemStack stack) {
        return this.supportsItemSlotInteractions() && this.container.canPlaceItem(this.getContainerSlot(), stack);
    }

    public double getDisplayAmount() {
        PlatformResourceKey resource = this.getResource();
        if (resource == null) {
            return 0.0;
        }
        return resource.getResourceType().getDisplayAmount(this.getAmount());
    }

    public double getMaxAmountWhenModifying() {
        PlatformResourceKey resource = this.getResource();
        if (!(resource instanceof PlatformResourceKey)) {
            return 0.0;
        }
        PlatformResourceKey platformResource = resource;
        return platformResource.getResourceType().getDisplayAmount(this.resourceContainer.getMaxAmount(resource));
    }

    public Component getHelpText() {
        return this.helpText;
    }

    public ResourceFactory getPrimaryResourceFactory() {
        return this.resourceContainer.getPrimaryResourceFactory();
    }

    public Set<ResourceFactory> getAlternativeResourceFactories() {
        return this.resourceContainer.getAlternativeResourceFactories();
    }

    @Nullable
    public ItemStack insertInto(ItemStack carried) {
        ResourceAmount currentResourceAmount = this.resourceContainer.get(this.getContainerSlot());
        if (currentResourceAmount == null) {
            return null;
        }
        return RefinedStorageApi.INSTANCE.getResourceContainerInsertStrategies().stream().flatMap(strategy -> strategy.insert(carried, currentResourceAmount).stream()).findFirst().map(result -> {
            this.resourceContainer.shrink(this.getContainerSlot(), result.inserted());
            return result.container();
        }).orElse(null);
    }

    public Component getClickToConfigureAmountHelpTooltip() {
        return CLICK_TO_CONFIGURE_AMOUNT;
    }
}

