/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.packet.c2s;

import com.refinedmods.refinedstorage.common.security.SecurityCardContainerMenu;
import com.refinedmods.refinedstorage.common.support.packet.PacketContext;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record SecurityCardBoundPlayerPacket(UUID playerId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SecurityCardBoundPlayerPacket> PACKET_TYPE = new CustomPacketPayload.Type(IdentifierUtil.createIdentifier("security_card_bound_player"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SecurityCardBoundPlayerPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, SecurityCardBoundPlayerPacket::playerId, SecurityCardBoundPlayerPacket::new);

    public static void handle(SecurityCardBoundPlayerPacket packet, PacketContext ctx) {
        Player player = ctx.getPlayer();
        MinecraftServer server = player.getServer();
        if (server == null) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof SecurityCardContainerMenu) {
            SecurityCardContainerMenu securityCardContainerMenu = (SecurityCardContainerMenu)abstractContainerMenu;
            securityCardContainerMenu.setBoundPlayer(server, packet.playerId);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }
}

