/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.widget;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.SearchFieldWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class AutoSelectedSideButtonWidget
extends AbstractSideButtonWidget {
    private static final List<MutableComponent> YES_LINES = List.of(IdentifierUtil.YES.copy().withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> NO_LINES = List.of(IdentifierUtil.NO.copy().withStyle(ChatFormatting.GRAY));
    private static final MutableComponent TITLE = IdentifierUtil.createTranslation("gui", "search_box_auto_selected");
    private static final ResourceLocation YES = IdentifierUtil.createIdentifier("widget/side_button/search_box_auto_selected/yes");
    private static final ResourceLocation NO = IdentifierUtil.createIdentifier("widget/side_button/search_box_auto_selected/no");
    private static final Component HELP = IdentifierUtil.createTranslation("gui", "search_box_auto_selected.help");

    public AutoSelectedSideButtonWidget(SearchFieldWidget searchFieldWidget) {
        super(AutoSelectedSideButtonWidget.createPressAction(searchFieldWidget));
    }

    private static Button.OnPress createPressAction(SearchFieldWidget searchFieldWidget) {
        return btn -> {
            boolean autoSelected = !Platform.INSTANCE.getConfig().isSearchBoxAutoSelected();
            Platform.INSTANCE.getConfig().setSearchBoxAutoSelected(autoSelected);
            searchFieldWidget.setAutoSelected(autoSelected);
        };
    }

    @Override
    protected ResourceLocation getSprite() {
        return Platform.INSTANCE.getConfig().isSearchBoxAutoSelected() ? YES : NO;
    }

    @Override
    protected MutableComponent getTitle() {
        return TITLE;
    }

    @Override
    protected List<MutableComponent> getSubText() {
        return Platform.INSTANCE.getConfig().isSearchBoxAutoSelected() ? YES_LINES : NO_LINES;
    }

    @Override
    protected Component getHelpText() {
        return HELP;
    }
}

