/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.energy.containers;

import java.util.function.Consumer;
import net.minecraft.world.item.ItemStack;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.SimpleEnergyStorage;

public class SimpleEnergyItemStorage
extends SimpleEnergyStorage {
    private final ItemStack stack;
    public Consumer<ItemStack> contextCallback;

    public SimpleEnergyItemStorage(long maxInsert, long maxExtract, long capacity, ItemStack stack) {
        super(maxInsert, maxExtract, capacity);
        this.stack = stack;
        this.setAmount((Long)stack.getOrDefault(EnergyApi.ITEM.getEnergyComponent(), (Object)0L));
    }

    @Override
    public void update() {
        super.update();
        this.stack.set(EnergyApi.ITEM.getEnergyComponent(), (Object)this.getAmount());
        if (this.contextCallback != null) {
            this.contextCallback.accept(this.stack);
        }
    }

    public SimpleEnergyItemStorage withCallback(Consumer<ItemStack> contextCallback) {
        this.contextCallback = contextCallback;
        return this;
    }
}

